/*
 * Decompiled with CFR 0.152.
 */
package net.daporkchop.lib.common.pool.handle;

import java.util.function.Supplier;
import lombok.NonNull;
import net.daporkchop.lib.common.pool.handle.BasicHandledPool;
import net.daporkchop.lib.common.pool.handle.Handle;
import net.daporkchop.lib.common.pool.handle.JavaRecyclingHandledPool;
import net.daporkchop.lib.common.pool.handle.RecyclingHandledPool;
import net.daporkchop.lib.common.ref.ReferenceType;

public interface HandledPool<V> {
    public static <V> HandledPool<V> global(@NonNull Supplier<V> factory, @NonNull ReferenceType referenceType, int maxCapacity) {
        if (factory == null) {
            throw new NullPointerException("factory");
        }
        if (referenceType == null) {
            throw new NullPointerException("referenceType");
        }
        return new BasicHandledPool<V>(factory, referenceType, maxCapacity);
    }

    public static <V> HandledPool<V> threadLocal(@NonNull Supplier<V> factory, int maxCapacityPerThread) {
        if (factory == null) {
            throw new NullPointerException("factory");
        }
        try {
            Class.forName("io.netty.util.Recycler");
            return new RecyclingHandledPool<V>(factory, maxCapacityPerThread);
        }
        catch (ClassNotFoundException e) {
            return new JavaRecyclingHandledPool<V>(factory, maxCapacityPerThread);
        }
    }

    public Handle<V> get();
}

