/*
 * Decompiled with CFR 0.152.
 */
package net.daporkchop.lib.common.pool.handle;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.function.Supplier;
import lombok.NonNull;
import net.daporkchop.lib.common.misc.refcount.AbstractRefCounted;
import net.daporkchop.lib.common.pool.handle.Handle;
import net.daporkchop.lib.common.pool.handle.HandledPool;
import net.daporkchop.lib.common.ref.Ref;
import net.daporkchop.lib.common.ref.ReferenceType;
import net.daporkchop.lib.common.util.PValidation;
import net.daporkchop.lib.unsafe.util.exception.AlreadyReleasedException;

final class BasicHandledPool<V>
implements HandledPool<V> {
    private final Deque<Ref<V>> deque;
    private final Supplier<V> factory;
    private final ReferenceType referenceType;
    private final int maxCapacity;

    public BasicHandledPool(@NonNull Supplier<V> factory, @NonNull ReferenceType referenceType, int maxCapacity) {
        if (factory == null) {
            throw new NullPointerException("factory");
        }
        if (referenceType == null) {
            throw new NullPointerException("referenceType");
        }
        this.deque = new ArrayDeque<Ref<V>>(PValidation.positive(maxCapacity, (Object)"maxCapacity"));
        this.factory = factory;
        this.referenceType = referenceType;
        this.maxCapacity = maxCapacity;
    }

    @Override
    public synchronized Handle<V> get() {
        Ref<Object> ref;
        Object value = null;
        while ((ref = this.deque.poll()) != null) {
            V v = ref.get();
            value = v;
            if (v == null) continue;
        }
        if (value == null) {
            value = this.factory.get();
            ref = this.referenceType.create(value);
        }
        return new HandleImpl(value, ref);
    }

    private final class HandleImpl
    extends AbstractRefCounted
    implements Handle<V> {
        @NonNull
        protected final V value;
        @NonNull
        protected final Ref<V> ref;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void doRelease() {
            BasicHandledPool basicHandledPool = BasicHandledPool.this;
            synchronized (basicHandledPool) {
                if (BasicHandledPool.this.deque.size() < BasicHandledPool.this.maxCapacity) {
                    BasicHandledPool.this.deque.addFirst(this.ref);
                }
            }
        }

        @Override
        public V get() {
            this.ensureNotReleased();
            return this.value;
        }

        @Override
        public Handle<V> retain() throws AlreadyReleasedException {
            super.retain();
            return this;
        }

        public HandleImpl(@NonNull V value, Ref<V> ref) {
            if (value == null) {
                throw new NullPointerException("value");
            }
            if (ref == null) {
                throw new NullPointerException("ref");
            }
            this.value = value;
            this.ref = ref;
        }
    }
}

