/*
 * Decompiled with CFR 0.152.
 */
package net.daporkchop.lib.common.pool.array;

import java.util.function.IntFunction;
import lombok.NonNull;
import net.daporkchop.lib.common.pool.array.AbstractArrayAllocator;

final class UnpooledArrayAllocator<V>
extends AbstractArrayAllocator<V> {
    public UnpooledArrayAllocator(@NonNull IntFunction<V> lambda) {
        super(lambda);
        if (lambda == null) {
            throw new NullPointerException("lambda");
        }
    }

    public UnpooledArrayAllocator(@NonNull Class<?> componentClass) {
        super(componentClass);
        if (componentClass == null) {
            throw new NullPointerException("componentClass");
        }
    }

    @Override
    public V atLeast(int length) {
        return this.exactly(length);
    }

    @Override
    public V exactly(int length) {
        return this.createArray(length);
    }

    @Override
    public void release(@NonNull V array) {
        if (array == null) {
            throw new NullPointerException("array");
        }
    }
}

