/*
 * Decompiled with CFR 0.152.
 */
package net.daporkchop.lib.common.pool.array;

import java.lang.reflect.Array;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.function.IntFunction;
import lombok.NonNull;
import net.daporkchop.lib.common.math.BinMath;
import net.daporkchop.lib.common.pool.array.AbstractArrayAllocator;
import net.daporkchop.lib.common.util.PArrays;
import net.daporkchop.lib.common.util.PValidation;
import net.daporkchop.lib.common.util.PorkUtil;

final class StrongPow2ArrayAllocator<V>
extends AbstractArrayAllocator<V> {
    protected final Deque<V>[] arenas = (Deque[])PorkUtil.uncheckedCast(PArrays.filled(32, Deque[]::new, ArrayDeque::new));
    protected final int maxCapacity;

    public StrongPow2ArrayAllocator(@NonNull IntFunction<V> lambda, int maxCapacity) {
        super(lambda);
        if (lambda == null) {
            throw new NullPointerException("lambda");
        }
        this.maxCapacity = PValidation.positive(maxCapacity, (Object)"maxCapacity");
    }

    public StrongPow2ArrayAllocator(@NonNull Class<?> componentClass, int maxCapacity) {
        super(componentClass);
        if (componentClass == null) {
            throw new NullPointerException("componentClass");
        }
        this.maxCapacity = PValidation.positive(maxCapacity, (Object)"maxCapacity");
    }

    @Override
    public V atLeast(int length) {
        return this.getPooled(PValidation.notNegative(length, (Object)"size"));
    }

    @Override
    public V exactly(int length) {
        PValidation.notNegative(length, (Object)"size");
        if (length != 0 && !BinMath.isPow2(length)) {
            return this.createArray(length);
        }
        return this.getPooled(length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected V getPooled(int length) {
        V value;
        Deque<V> arena;
        int bits = length == 0 ? 0 : 31 - Integer.numberOfLeadingZeros(length - 1);
        Deque<V> deque = arena = this.arenas[bits];
        synchronized (deque) {
            value = arena.poll();
        }
        if (value == null) {
            value = this.createArray(2 << bits);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release(@NonNull V array) {
        Deque<V> arena;
        if (array == null) {
            throw new NullPointerException("array");
        }
        int length = Array.getLength(array);
        int bits = length == 0 ? 0 : 31 - Integer.numberOfLeadingZeros(length - 1);
        Deque<V> deque = arena = this.arenas[bits];
        synchronized (deque) {
            if (arena.size() < this.maxCapacity) {
                arena.addFirst(array);
            }
        }
    }
}

