/*
 * Decompiled with CFR 0.152.
 */
package net.daporkchop.lib.common.pool.array;

import java.lang.reflect.Array;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.function.IntFunction;
import lombok.NonNull;
import net.daporkchop.lib.common.math.BinMath;
import net.daporkchop.lib.common.pool.array.AbstractArrayAllocator;
import net.daporkchop.lib.common.ref.Ref;
import net.daporkchop.lib.common.ref.ReferenceType;
import net.daporkchop.lib.common.util.PArrays;
import net.daporkchop.lib.common.util.PValidation;
import net.daporkchop.lib.common.util.PorkUtil;

final class ReferencedPow2ArrayAllocator<V>
extends AbstractArrayAllocator<V> {
    protected final Deque<Ref<V>>[] arenas = (Deque[])PorkUtil.uncheckedCast(PArrays.filled(32, Deque[]::new, ArrayDeque::new));
    protected final ReferenceType referenceType;
    protected final int maxCapacity;

    public ReferencedPow2ArrayAllocator(@NonNull IntFunction<V> lambda, @NonNull ReferenceType referenceType, int maxCapacity) {
        super(lambda);
        if (lambda == null) {
            throw new NullPointerException("lambda");
        }
        if (referenceType == null) {
            throw new NullPointerException("referenceType");
        }
        this.referenceType = referenceType;
        this.maxCapacity = PValidation.positive(maxCapacity, (Object)"maxCapacity");
    }

    public ReferencedPow2ArrayAllocator(@NonNull Class<?> componentClass, @NonNull ReferenceType referenceType, int maxCapacity) {
        super(componentClass);
        if (componentClass == null) {
            throw new NullPointerException("componentClass");
        }
        if (referenceType == null) {
            throw new NullPointerException("referenceType");
        }
        this.referenceType = referenceType;
        this.maxCapacity = PValidation.positive(maxCapacity, (Object)"maxCapacity");
    }

    @Override
    public V atLeast(int length) {
        return this.getPooled(PValidation.notNegative(length, (Object)"size"));
    }

    @Override
    public V exactly(int length) {
        PValidation.notNegative(length, (Object)"size");
        if (length != 0 && !BinMath.isPow2(length)) {
            return this.createArray(length);
        }
        return this.getPooled(length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected V getPooled(int length) {
        int bits = length == 0 ? 0 : 31 - Integer.numberOfLeadingZeros(length - 1);
        Deque<Ref<V>> arena = this.arenas[bits];
        V value = null;
        Deque<Ref<V>> deque = arena;
        synchronized (deque) {
            Ref<V> ref;
            while ((ref = arena.poll()) != null) {
                V v = ref.get();
                value = v;
                if (v == null) continue;
            }
        }
        if (value == null) {
            value = this.createArray(2 << bits);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release(@NonNull V array) {
        Deque<Ref<V>> arena;
        if (array == null) {
            throw new NullPointerException("array");
        }
        int length = Array.getLength(array);
        int bits = length == 0 ? 0 : 31 - Integer.numberOfLeadingZeros(length - 1);
        Deque<Ref<V>> deque = arena = this.arenas[bits];
        synchronized (deque) {
            if (arena.size() < this.maxCapacity) {
                arena.addFirst(this.referenceType.create(array));
            }
        }
    }
}

