/*
 * Decompiled with CFR 0.152.
 */
package net.daporkchop.lib.common.pool.array;

import java.util.function.IntFunction;
import lombok.NonNull;
import net.daporkchop.lib.common.pool.array.ReferencedPow2ArrayAllocator;
import net.daporkchop.lib.common.pool.array.StrongPow2ArrayAllocator;
import net.daporkchop.lib.common.pool.array.UnpooledArrayAllocator;
import net.daporkchop.lib.common.ref.ReferenceType;

public interface ArrayAllocator<T> {
    public static <T> ArrayAllocator<T> pow2(@NonNull IntFunction<T> lambda, @NonNull ReferenceType referenceType, int maxCapacity) {
        if (lambda == null) {
            throw new NullPointerException("lambda");
        }
        if (referenceType == null) {
            throw new NullPointerException("referenceType");
        }
        if (referenceType == ReferenceType.STRONG) {
            return new StrongPow2ArrayAllocator<T>(lambda, maxCapacity);
        }
        return new ReferencedPow2ArrayAllocator<T>(lambda, referenceType, maxCapacity);
    }

    public static <T> ArrayAllocator<T> pow2(@NonNull Class<?> componentType, @NonNull ReferenceType referenceType, int maxCapacity) {
        if (componentType == null) {
            throw new NullPointerException("componentType");
        }
        if (referenceType == null) {
            throw new NullPointerException("referenceType");
        }
        if (referenceType == ReferenceType.STRONG) {
            return new StrongPow2ArrayAllocator(componentType, maxCapacity);
        }
        return new ReferencedPow2ArrayAllocator(componentType, referenceType, maxCapacity);
    }

    public static <T> ArrayAllocator<T> unpooled(@NonNull IntFunction<T> lambda) {
        if (lambda == null) {
            throw new NullPointerException("lambda");
        }
        return new UnpooledArrayAllocator<T>(lambda);
    }

    public static <T> ArrayAllocator<T> unpooled(@NonNull Class<?> componentType) {
        if (componentType == null) {
            throw new NullPointerException("componentType");
        }
        return new UnpooledArrayAllocator(componentType);
    }

    public T atLeast(int var1);

    public T exactly(int var1);

    public void release(@NonNull T var1);
}

