/*
 * Decompiled with CFR 0.152.
 */
package net.daporkchop.lib.common.pool.array;

import java.lang.reflect.Array;
import java.util.function.IntFunction;
import lombok.NonNull;
import net.daporkchop.lib.common.pool.array.ArrayAllocator;
import net.daporkchop.lib.common.util.PValidation;
import net.daporkchop.lib.common.util.PorkUtil;

public abstract class AbstractArrayAllocator<V>
implements ArrayAllocator<V> {
    protected final IntFunction<V> lambda;
    protected final Class<?> componentClass;

    public AbstractArrayAllocator(@NonNull IntFunction<V> lambda) {
        this(lambda, null);
        if (lambda == null) {
            throw new NullPointerException("lambda");
        }
        PValidation.checkArg(lambda.apply(0).getClass().isArray(), "Provided array creator is not an array type!");
    }

    public AbstractArrayAllocator(@NonNull Class<?> componentClass) {
        this(null, componentClass);
        if (componentClass == null) {
            throw new NullPointerException("componentClass");
        }
    }

    protected V createArray(int length) {
        if (this.lambda != null) {
            return this.lambda.apply(length);
        }
        return (V)PorkUtil.uncheckedCast(Array.newInstance(this.componentClass, length));
    }

    private AbstractArrayAllocator(IntFunction<V> lambda, Class<?> componentClass) {
        this.lambda = lambda;
        this.componentClass = componentClass;
    }
}

