/*
 * Decompiled with CFR 0.152.
 */
package net.daporkchop.lib.common.misc.threadfactory;

import java.util.concurrent.ThreadFactory;
import net.daporkchop.lib.common.misc.threadfactory.CollapsingIncrementingNamedThreadFactory;
import net.daporkchop.lib.common.misc.threadfactory.FixedNamedThreadFactory;
import net.daporkchop.lib.common.misc.threadfactory.IncrementingNamedThreadFactory;
import net.daporkchop.lib.common.misc.threadfactory.PThreadFactories;
import net.daporkchop.lib.common.misc.threadfactory.UnnamedThreadFactory;
import net.daporkchop.lib.common.util.PValidation;

public class ThreadFactoryBuilder {
    protected String name;
    protected ClassLoader contextClassLoader;
    protected Thread.UncaughtExceptionHandler uncaughtExceptionHandler;
    protected int priority = 5;
    protected boolean daemon;
    protected boolean formatId;
    protected boolean collapsingId;

    public ThreadFactoryBuilder daemon() {
        return this.daemon(true);
    }

    public ThreadFactoryBuilder formatId() {
        return this.formatId(true);
    }

    public ThreadFactoryBuilder collapsingId() {
        return this.formatId(true).collapsingId(true);
    }

    public ThreadFactoryBuilder priority(int priority) {
        PValidation.checkArg(priority >= 1 && priority <= 10, "invalid priority: %d (must be in range [%d-%d])", priority, 1, 10);
        this.priority = priority;
        return this;
    }

    public ThreadFactoryBuilder minPriority() {
        return this.priority(1);
    }

    public ThreadFactoryBuilder maxPriority() {
        return this.priority(10);
    }

    public ThreadFactory build() {
        if (!this.formatId) {
            if (this.name == null) {
                if (this.contextClassLoader == null && this.uncaughtExceptionHandler == null && this.priority == 5 && !this.daemon) {
                    return PThreadFactories.DEFAULT_THREAD_FACTORY;
                }
                return new UnnamedThreadFactory(this.contextClassLoader, this.uncaughtExceptionHandler, this.priority, this.daemon);
            }
            return new FixedNamedThreadFactory(this.name, this.contextClassLoader, this.uncaughtExceptionHandler, this.priority, this.daemon);
        }
        if (this.name == null) {
            throw new IllegalStateException("formatId is set, but no name is given!");
        }
        if (this.collapsingId) {
            return new CollapsingIncrementingNamedThreadFactory(this.name, this.contextClassLoader, this.uncaughtExceptionHandler, this.priority, this.daemon);
        }
        return new IncrementingNamedThreadFactory(this.name, this.contextClassLoader, this.uncaughtExceptionHandler, this.priority, this.daemon);
    }

    @Deprecated
    public ThreadFactoryBuilder() {
    }

    public ThreadFactoryBuilder name(String name) {
        this.name = name;
        return this;
    }

    public ThreadFactoryBuilder contextClassLoader(ClassLoader contextClassLoader) {
        this.contextClassLoader = contextClassLoader;
        return this;
    }

    public ThreadFactoryBuilder uncaughtExceptionHandler(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.uncaughtExceptionHandler = uncaughtExceptionHandler;
        return this;
    }

    public ThreadFactoryBuilder daemon(boolean daemon) {
        this.daemon = daemon;
        return this;
    }

    public ThreadFactoryBuilder formatId(boolean formatId) {
        this.formatId = formatId;
        return this;
    }

    public ThreadFactoryBuilder collapsingId(boolean collapsingId) {
        this.collapsingId = collapsingId;
        return this;
    }
}

