/*
 * Decompiled with CFR 0.152.
 */
package net.daporkchop.lib.common.misc.threadfactory;

import java.util.concurrent.atomic.AtomicInteger;
import lombok.NonNull;
import net.daporkchop.lib.common.misc.threadfactory.AbstractThreadFactory;

public final class IncrementingNamedThreadFactory
extends AbstractThreadFactory {
    protected final String format;
    protected final AtomicInteger counter = new AtomicInteger();

    public IncrementingNamedThreadFactory(@NonNull String format, ClassLoader contextClassLoader, Thread.UncaughtExceptionHandler uncaughtExceptionHandler, int priority, boolean daemon) {
        super(contextClassLoader, uncaughtExceptionHandler, priority, daemon);
        if (format == null) {
            throw new NullPointerException("format");
        }
        this.format = format;
    }

    @Override
    protected String getName(Runnable task, Runnable wrappedTask, Thread thread) {
        return String.format(this.format, this.counter.getAndIncrement());
    }

    public String format() {
        return this.format;
    }
}

