/*
 * Decompiled with CFR 0.152.
 */
package net.daporkchop.lib.common.misc.threadfactory;

import java.util.BitSet;
import lombok.NonNull;
import net.daporkchop.lib.common.misc.threadfactory.AbstractThreadFactory;

public final class CollapsingIncrementingNamedThreadFactory
extends AbstractThreadFactory {
    protected final String format;
    protected final BitSet usedIds = new BitSet();

    public CollapsingIncrementingNamedThreadFactory(@NonNull String format, ClassLoader contextClassLoader, Thread.UncaughtExceptionHandler uncaughtExceptionHandler, int priority, boolean daemon) {
        super(contextClassLoader, uncaughtExceptionHandler, priority, daemon);
        if (format == null) {
            throw new NullPointerException("format");
        }
        this.format = format;
    }

    @Override
    protected Runnable wrapTask(Runnable task) {
        return new TaskWrapper(task);
    }

    @Override
    protected String getName(Runnable task, Runnable wrappedTask, Thread thread) {
        return String.format(this.format, ((TaskWrapper)wrappedTask).id);
    }

    public String format() {
        return this.format;
    }

    private final class TaskWrapper
    implements Runnable {
        protected final Runnable delegate;
        protected final int id;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TaskWrapper(Runnable delegate) {
            BitSet usedIds;
            if (delegate == null) {
                throw new NullPointerException("delegate");
            }
            this.delegate = delegate;
            BitSet bitSet = usedIds = CollapsingIncrementingNamedThreadFactory.this.usedIds;
            synchronized (bitSet) {
                this.id = usedIds.nextClearBit(0);
                usedIds.set(this.id);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.delegate.run();
            }
            finally {
                BitSet usedIds;
                BitSet bitSet = usedIds = CollapsingIncrementingNamedThreadFactory.this.usedIds;
                synchronized (bitSet) {
                    usedIds.clear(this.id);
                }
            }
        }
    }
}

