/*
 * Decompiled with CFR 0.152.
 */
package net.daporkchop.lib.common.misc.threadfactory;

import java.util.concurrent.ThreadFactory;
import net.daporkchop.lib.common.misc.threadfactory.PThreadFactories;

public abstract class AbstractThreadFactory
implements ThreadFactory {
    protected final ClassLoader contextClassLoader;
    protected final Thread.UncaughtExceptionHandler uncaughtExceptionHandler;
    protected final int priority;
    protected final boolean daemon;

    @Override
    public Thread newThread(Runnable task) {
        Thread thread;
        Runnable wrappedTask = this.wrapTask(task);
        String name = this.getName(task, wrappedTask, thread = PThreadFactories.DEFAULT_THREAD_FACTORY.newThread(wrappedTask));
        if (name != null) {
            thread.setName(name);
        }
        if (this.contextClassLoader != null) {
            thread.setContextClassLoader(this.contextClassLoader);
        }
        if (this.uncaughtExceptionHandler != null) {
            thread.setUncaughtExceptionHandler(this.uncaughtExceptionHandler);
        }
        thread.setPriority(this.priority);
        thread.setDaemon(this.daemon);
        return thread;
    }

    protected Runnable wrapTask(Runnable task) {
        return task;
    }

    protected abstract String getName(Runnable var1, Runnable var2, Thread var3);

    public AbstractThreadFactory(ClassLoader contextClassLoader, Thread.UncaughtExceptionHandler uncaughtExceptionHandler, int priority, boolean daemon) {
        this.contextClassLoader = contextClassLoader;
        this.uncaughtExceptionHandler = uncaughtExceptionHandler;
        this.priority = priority;
        this.daemon = daemon;
    }

    public ClassLoader contextClassLoader() {
        return this.contextClassLoader;
    }

    public Thread.UncaughtExceptionHandler uncaughtExceptionHandler() {
        return this.uncaughtExceptionHandler;
    }

    public int priority() {
        return this.priority;
    }

    public boolean daemon() {
        return this.daemon;
    }
}

