/*
 * Decompiled with CFR 0.152.
 */
package net.daporkchop.lib.common.misc.string;

import lombok.NonNull;
import net.daporkchop.lib.common.misc.string.PUnsafeStrings;

public final class StringGroup {
    protected final char[][] values;
    protected final int totalLength;

    StringGroup(@NonNull char[][] values) {
        if (values == null) {
            throw new NullPointerException("values");
        }
        this.values = values;
        int totalLength = 0;
        for (char[] arr : values) {
            if ((totalLength += arr.length) >= 0) continue;
            throw new IllegalArgumentException("integer overflow");
        }
        this.totalLength = totalLength;
    }

    public StringGroup titleFormat() {
        for (char[] arr : this.values) {
            PUnsafeStrings.titleFormat(arr);
        }
        return this;
    }

    public String join(char glue) {
        if (this.values.length == 0) {
            return "";
        }
        if (this.values.length == 1) {
            return PUnsafeStrings.wrap(this.values[0]);
        }
        if (this.totalLength + this.values.length < 0) {
            throw new IllegalArgumentException("integer overflow");
        }
        char[] dst = new char[this.totalLength + this.values.length - 1];
        int i = this.values[0].length;
        System.arraycopy(this.values[0], 0, dst, 0, i);
        int length = this.values.length;
        for (int j = 1; j < length; ++j) {
            char[] arr = this.values[j];
            dst[i++] = glue;
            System.arraycopy(arr, 0, dst, i, arr.length);
            i += arr.length;
        }
        return PUnsafeStrings.wrap(dst);
    }
}

