/*
 * Decompiled with CFR 0.152.
 */
package net.daporkchop.lib.common.misc.string;

import lombok.NonNull;
import net.daporkchop.lib.common.util.PorkUtil;
import net.daporkchop.lib.unsafe.PUnsafe;

public final class PUnsafeStrings {
    protected static final long STRING_VALUE_OFFSET = PUnsafe.pork_getOffset(String.class, "value");
    protected static final long STRING_HASH_OFFSET = PUnsafe.pork_getOffset(String.class, "hash");
    protected static final long ENUM_NAME_OFFSET = PUnsafe.pork_getOffset(Enum.class, "name");
    protected static final long STRINGBUILDER_VALUE_OFFSET = PUnsafe.pork_getOffset(PorkUtil.classForName("java.lang.AbstractStringBuilder"), "value");

    public static <E extends Enum<E>> void setEnumName(@NonNull E value, @NonNull String name) {
        if (value == null) {
            throw new NullPointerException("value");
        }
        if (name == null) {
            throw new NullPointerException("name");
        }
        PUnsafe.putObject(value, ENUM_NAME_OFFSET, name);
    }

    public static void replace(@NonNull String text, char find, char replace) {
        if (text == null) {
            throw new NullPointerException("text");
        }
        PUnsafeStrings.replace(PUnsafeStrings.unwrap(text), find, replace);
        PUnsafe.putInt(text, STRING_HASH_OFFSET, 0);
    }

    public static void replace(@NonNull char[] text, char find, char replace) {
        if (text == null) {
            throw new NullPointerException("text");
        }
        int length = text.length;
        for (int i = 0; i < length; ++i) {
            if (text[i] != find) continue;
            text[i] = replace;
        }
    }

    public static void titleFormat(@NonNull String text) {
        if (text == null) {
            throw new NullPointerException("text");
        }
        PUnsafeStrings.titleFormat(PUnsafeStrings.unwrap(text));
        PUnsafe.putInt(text, STRING_HASH_OFFSET, 0);
    }

    public static void titleFormat(@NonNull char[] text) {
        if (text == null) {
            throw new NullPointerException("text");
        }
        int length = text.length;
        if (length > 0) {
            text[0] = Character.toUpperCase(text[0]);
            for (int i = 1; i < length; ++i) {
                text[i] = Character.toLowerCase(text[i]);
            }
        }
    }

    public static String wrap(@NonNull char[] chars) {
        if (chars == null) {
            throw new NullPointerException("chars");
        }
        String s2 = PUnsafe.allocateInstance(String.class);
        PUnsafe.putObject(s2, STRING_VALUE_OFFSET, chars);
        return s2;
    }

    public static char[] tryUnwrap(@NonNull CharSequence seq) {
        if (seq == null) {
            throw new NullPointerException("seq");
        }
        if (seq instanceof String) {
            return (char[])PUnsafe.getObject(seq, STRING_VALUE_OFFSET);
        }
        if (seq instanceof StringBuilder || seq instanceof StringBuffer) {
            return (char[])PUnsafe.getObject(seq, STRINGBUILDER_VALUE_OFFSET);
        }
        return null;
    }

    public static char[] unwrap(@NonNull String string) {
        if (string == null) {
            throw new NullPointerException("string");
        }
        return (char[])PUnsafe.getObject(string, STRING_VALUE_OFFSET);
    }

    public static char[] unwrap(@NonNull StringBuilder builder) {
        if (builder == null) {
            throw new NullPointerException("builder");
        }
        return (char[])PUnsafe.getObject(builder, STRINGBUILDER_VALUE_OFFSET);
    }

    public static char[] unwrap(@NonNull StringBuffer buffer) {
        if (buffer == null) {
            throw new NullPointerException("buffer");
        }
        return (char[])PUnsafe.getObject(buffer, STRINGBUILDER_VALUE_OFFSET);
    }

    private PUnsafeStrings() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

