/*
 * Decompiled with CFR 0.152.
 */
package net.daporkchop.lib.common.misc.string;

import java.util.Arrays;
import java.util.Formatter;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Objects;
import lombok.NonNull;
import net.daporkchop.lib.common.misc.string.PUnsafeStrings;
import net.daporkchop.lib.common.misc.string.StringGroup;
import net.daporkchop.lib.common.pool.handle.Handle;
import net.daporkchop.lib.common.util.PArrays;
import net.daporkchop.lib.common.util.PValidation;
import net.daporkchop.lib.common.util.PorkUtil;

public final class PStrings {
    public static StringGroup split(@NonNull String src, char delimiter) {
        if (src == null) {
            throw new NullPointerException("src");
        }
        return PStrings.split(PUnsafeStrings.unwrap(src), delimiter);
    }

    public static StringGroup split(@NonNull char[] src, char delimiter) {
        int next;
        if (src == null) {
            throw new NullPointerException("src");
        }
        int length = src.length;
        LinkedList<char[]> list = new LinkedList<char[]>();
        int off = 0;
        while ((next = PArrays.indexOf(src, delimiter, off, length)) != -1) {
            list.add(Arrays.copyOfRange(src, off, next));
            off = next + 1;
        }
        list.add(Arrays.copyOfRange(src, off, length));
        return new StringGroup((char[][])list.toArray((T[])new char[list.size()][]));
    }

    public static String clone(@NonNull String src) {
        if (src == null) {
            throw new NullPointerException("src");
        }
        return PUnsafeStrings.wrap((char[])PUnsafeStrings.unwrap(src).clone());
    }

    public static void appendMany(@NonNull StringBuilder builder, char c, int count) {
        if (builder == null) {
            throw new NullPointerException("builder");
        }
        if (PValidation.notNegative(count, (Object)"count") == 0) {
            return;
        }
        int initialLength = builder.length();
        builder.setLength(initialLength + count);
        Arrays.fill(PUnsafeStrings.unwrap(builder), initialLength, initialLength + count, c);
    }

    public static String lightFormat(@NonNull String template, Object ... args) {
        if (template == null) {
            throw new NullPointerException("template");
        }
        return PUnsafeStrings.wrap(PStrings.lightFormat(PUnsafeStrings.unwrap(template), args));
    }

    public static char[] lightFormat(@NonNull char[] template, Object ... args) {
        if (template == null) {
            throw new NullPointerException("template");
        }
        if (args == null) {
            args = PorkUtil.EMPTY_OBJECT_ARRAY;
        }
        try (Handle<StringBuilder> handle = PorkUtil.STRINGBUILDER_POOL.get();){
            StringBuilder builder = handle.get();
            builder.setLength(0);
            int length = template.length;
            int j = 0;
            for (int i = 0; i < length; ++i) {
                char c = template[i];
                if (c == '%' && i + 1 < length && template[i + 1] == 's') {
                    builder.append(Objects.toString(j < args.length ? args[j++] : null));
                    ++i;
                    continue;
                }
                builder.append(c);
            }
            char[] cArray = Arrays.copyOf(PUnsafeStrings.unwrap(builder), builder.length());
            return cArray;
        }
    }

    public static String fastFormat(@NonNull String template, Object ... args) {
        if (template == null) {
            throw new NullPointerException("template");
        }
        try (Handle<StringBuilder> handle = PorkUtil.STRINGBUILDER_POOL.get();){
            StringBuilder builder = handle.get();
            builder.setLength(0);
            new Formatter(builder, Locale.US).format(template, args);
            String string = builder.toString();
            return string;
        }
    }

    private PStrings() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

