/*
 * Decompiled with CFR 0.152.
 */
package net.daporkchop.lib.common.misc.refcount;

import net.daporkchop.lib.common.misc.refcount.AbstractRefCounted;
import net.daporkchop.lib.unsafe.PCleaner;
import net.daporkchop.lib.unsafe.PUnsafe;
import net.daporkchop.lib.unsafe.util.exception.AlreadyReleasedException;

public final class RefCountedDirectMemory
extends AbstractRefCounted {
    private final long addr;
    private final long size;
    private final PCleaner cleaner;

    public RefCountedDirectMemory(long size) {
        this(PUnsafe.allocateMemory(size), size, true);
    }

    public RefCountedDirectMemory(long addr, long size, boolean doFree) {
        this.addr = addr;
        this.size = size;
        this.cleaner = doFree ? PCleaner.cleaner((Object)this, addr) : null;
    }

    @Override
    public RefCountedDirectMemory retain() throws AlreadyReleasedException {
        super.retain();
        return this;
    }

    @Override
    protected void doRelease() {
        if (this.cleaner != null) {
            this.cleaner.clean();
        }
    }

    public String toString() {
        return "RefCountedDirectMemory(addr=" + this.addr() + ", size=" + this.size() + ", cleaner=" + this.cleaner() + ")";
    }

    public long addr() {
        return this.addr;
    }

    public long size() {
        return this.size;
    }

    public PCleaner cleaner() {
        return this.cleaner;
    }
}

