/*
 * Decompiled with CFR 0.152.
 */
package net.daporkchop.lib.common.misc.refcount;

import lombok.NonNull;
import net.daporkchop.lib.common.misc.refcount.RefCounted;
import net.daporkchop.lib.unsafe.PUnsafe;
import net.daporkchop.lib.unsafe.util.exception.AlreadyReleasedException;

public abstract class AbstractRefCounted
implements RefCounted {
    protected static final long REFCNT_OFFSET = PUnsafe.pork_getOffset(AbstractRefCounted.class, "refCnt");
    private volatile int refCnt = 1;

    @Override
    public RefCounted retain() throws AlreadyReleasedException {
        int refCnt;
        do {
            if ((refCnt = PUnsafe.getIntVolatile(this, REFCNT_OFFSET)) != 0) continue;
            throw new AlreadyReleasedException();
        } while (!PUnsafe.compareAndSwapInt(this, REFCNT_OFFSET, refCnt, refCnt + 1));
        return this;
    }

    @Override
    public boolean release() throws AlreadyReleasedException {
        int refCnt;
        do {
            if ((refCnt = PUnsafe.getIntVolatile(this, REFCNT_OFFSET)) != 0) continue;
            throw new AlreadyReleasedException();
        } while (!PUnsafe.compareAndSwapInt(this, REFCNT_OFFSET, refCnt, refCnt - 1));
        if (refCnt == 1) {
            this.doRelease();
            return true;
        }
        return false;
    }

    protected abstract void doRelease();

    protected void ensureNotReleased() {
        if (PUnsafe.getIntVolatile(this, REFCNT_OFFSET) == 0) {
            throw new AlreadyReleasedException();
        }
    }

    @Override
    public int refCnt() {
        return this.refCnt;
    }

    public static abstract class Synchronized
    extends AbstractRefCounted {
        protected final Object mutex;

        public Synchronized() {
            this.mutex = this;
        }

        public Synchronized(@NonNull Object mutex) {
            if (mutex == null) {
                throw new NullPointerException("mutex");
            }
            this.mutex = mutex;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public RefCounted retain() throws AlreadyReleasedException {
            Object object = this.mutex;
            synchronized (object) {
                return super.retain();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean release() throws AlreadyReleasedException {
            Object object = this.mutex;
            synchronized (object) {
                return super.release();
            }
        }
    }
}

