/*
 * Decompiled with CFR 0.152.
 */
package net.daporkchop.lib.common.misc.file;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.ExecutionException;
import java.util.stream.StreamSupport;
import lombok.NonNull;
import net.daporkchop.lib.common.util.exception.file.CannotCreateDirectoryException;
import net.daporkchop.lib.common.util.exception.file.CannotCreateFileException;
import net.daporkchop.lib.common.util.exception.file.CannotDeleteFileException;
import net.daporkchop.lib.common.util.exception.file.NoSuchDirectoryException;
import net.daporkchop.lib.common.util.exception.file.NoSuchFileException;
import net.daporkchop.lib.common.util.exception.file.NotADirectoryException;
import net.daporkchop.lib.common.util.exception.file.NotAFileException;

public final class PFiles {
    public static File ensureDirectoryExists(@NonNull File directory) throws CannotCreateDirectoryException, NotADirectoryException {
        if (directory == null) {
            throw new NullPointerException("directory");
        }
        if (!(directory.exists() || directory.mkdirs() || directory.exists())) {
            throw new CannotCreateDirectoryException(directory);
        }
        if (!directory.isDirectory()) {
            throw new NotADirectoryException(directory);
        }
        return directory;
    }

    public static File ensureParentDirectoryExists(@NonNull File file) throws CannotCreateDirectoryException, NotADirectoryException {
        if (file == null) {
            throw new NullPointerException("file");
        }
        PFiles.ensureDirectoryExists(file.getAbsoluteFile().getParentFile());
        return file;
    }

    public static File ensureFileExists(@NonNull File file) throws CannotCreateFileException, CannotCreateDirectoryException, NotAFileException, NotADirectoryException {
        if (file == null) {
            throw new NullPointerException("file");
        }
        if (!file.exists()) {
            File parentFile;
            if (!file.isAbsolute()) {
                file = file.getAbsoluteFile();
            }
            if ((parentFile = file.getParentFile()) != null) {
                PFiles.ensureDirectoryExists(file.getParentFile());
            }
            try {
                if (!file.createNewFile() && !file.exists()) {
                    throw new CannotCreateFileException(file);
                }
            }
            catch (IOException e) {
                throw new CannotCreateFileException(file, (Throwable)e);
            }
        }
        if (!file.isFile()) {
            throw new NotAFileException(file);
        }
        return file;
    }

    public static boolean checkDirectoryExists(@NonNull File directory) throws NotADirectoryException {
        if (directory == null) {
            throw new NullPointerException("directory");
        }
        if (directory.exists()) {
            if (directory.isDirectory()) {
                return true;
            }
            throw new NotADirectoryException(directory);
        }
        return false;
    }

    public static boolean checkFileExists(@NonNull File file) throws NotAFileException {
        if (file == null) {
            throw new NullPointerException("file");
        }
        if (file.exists()) {
            if (file.isFile()) {
                return true;
            }
            throw new NotAFileException(file);
        }
        return false;
    }

    public static File assertDirectoryExists(@NonNull File directory) throws NoSuchDirectoryException, NotADirectoryException {
        if (directory == null) {
            throw new NullPointerException("directory");
        }
        if (directory.exists()) {
            if (directory.isDirectory()) {
                return directory;
            }
            throw new NotADirectoryException(directory);
        }
        throw new NoSuchDirectoryException(directory);
    }

    public static File assertFileExists(@NonNull File file) throws NoSuchFileException, NotAFileException {
        if (file == null) {
            throw new NullPointerException("file");
        }
        if (file.exists()) {
            if (file.isFile()) {
                return file;
            }
            throw new NotAFileException(file);
        }
        throw new NoSuchFileException(file);
    }

    public static void rm(@NonNull File file) throws CannotDeleteFileException {
        if (file == null) {
            throw new NullPointerException("file");
        }
        while (file.exists()) {
            if (file.isDirectory()) {
                File[] files;
                while ((files = file.listFiles()) != null && files.length != 0) {
                    for (File f : files) {
                        PFiles.rm(f);
                    }
                }
            }
            if (file.delete()) continue;
            throw new CannotDeleteFileException(file);
        }
    }

    public static void rmParallel(@NonNull File file) throws CannotDeleteFileException {
        if (file == null) {
            throw new NullPointerException("file");
        }
        try {
            while (file.exists()) {
                if (file.isDirectory()) {
                    File[] files;
                    while ((files = file.listFiles()) != null && files.length != 0) {
                        StreamSupport.stream(Arrays.spliterator(files), true).forEach(PFiles::rmParallel);
                    }
                }
                if (file.delete()) continue;
                throw new CannotDeleteFileException(file);
            }
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof CannotDeleteFileException) {
                throw (CannotDeleteFileException)e.getCause();
            }
            throw new RuntimeException(e);
        }
    }

    public static void rmContents(@NonNull File directory) throws NotADirectoryException, CannotDeleteFileException {
        if (directory == null) {
            throw new NullPointerException("directory");
        }
        if (PFiles.checkDirectoryExists(directory)) {
            File[] files;
            while ((files = directory.listFiles()) != null && files.length != 0) {
                for (File f : files) {
                    PFiles.rm(f);
                }
            }
        }
    }

    public static void rmContentsParallel(@NonNull File directory) throws NotADirectoryException, CannotDeleteFileException {
        if (directory == null) {
            throw new NullPointerException("directory");
        }
        if (PFiles.checkDirectoryExists(directory)) {
            try {
                File[] files;
                while ((files = directory.listFiles()) != null && files.length != 0) {
                    StreamSupport.stream(Arrays.spliterator(files), true).forEach(PFiles::rmParallel);
                }
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof CannotDeleteFileException) {
                    throw (CannotDeleteFileException)e.getCause();
                }
                throw new RuntimeException(e);
            }
        }
    }

    private PFiles() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

