/*
 * Decompiled with CFR 0.152.
 */
package net.daporkchop.lib.common.misc;

import net.daporkchop.lib.unsafe.PUnsafe;

public final class Tuple<A, B> {
    protected static final long A_OFFSET = PUnsafe.pork_getOffset(Tuple.class, "a");
    protected static final long B_OFFSET = PUnsafe.pork_getOffset(Tuple.class, "b");
    protected A a;
    protected B b;

    public boolean isANull() {
        return this.a == null;
    }

    public boolean isANonNull() {
        return this.a != null;
    }

    public boolean isBNull() {
        return this.b == null;
    }

    public boolean isBNonNull() {
        return this.b != null;
    }

    public Tuple<A, B> atomicSetA(A a) {
        PUnsafe.putObjectVolatile(this, A_OFFSET, a);
        return this;
    }

    public Tuple<A, B> atomicSetB(B b) {
        PUnsafe.putObjectVolatile(this, B_OFFSET, b);
        return this;
    }

    public A atomicSwapA(A a) {
        return (A)PUnsafe.pork_swapObject(this, A_OFFSET, a);
    }

    public B atomicSwapB(B b) {
        return (B)PUnsafe.pork_swapObject(this, B_OFFSET, b);
    }

    public Tuple() {
    }

    public Tuple(A a, B b) {
        this.a = a;
        this.b = b;
    }

    public A getA() {
        return this.a;
    }

    public B getB() {
        return this.b;
    }

    public Tuple<A, B> setA(A a) {
        this.a = a;
        return this;
    }

    public Tuple<A, B> setB(B b) {
        this.b = b;
        return this;
    }

    public String toString() {
        return "Tuple(a=" + this.getA() + ", b=" + this.getB() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Tuple)) {
            return false;
        }
        Tuple other = (Tuple)o;
        A this$a = this.getA();
        A other$a = other.getA();
        if (this$a == null ? other$a != null : !this$a.equals(other$a)) {
            return false;
        }
        B this$b = this.getB();
        B other$b = other.getB();
        return !(this$b == null ? other$b != null : !this$b.equals(other$b));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        A $a = this.getA();
        result = result * 59 + ($a == null ? 43 : $a.hashCode());
        B $b = this.getB();
        result = result * 59 + ($b == null ? 43 : $b.hashCode());
        return result;
    }
}

