/*
 * Decompiled with CFR 0.152.
 */
package net.daporkchop.lib.common.misc;

import java.lang.ref.SoftReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.NonNull;

public final class InstancePool {
    private static final Map<Class<?>, SoftReference<?>> MAP = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T getInstance(@NonNull Class<T> clazz) {
        Object val;
        if (clazz == null) {
            throw new NullPointerException("clazz");
        }
        SoftReference<?> ref = MAP.computeIfAbsent(clazz, c -> new SoftReference(InstancePool.createInstance(c)));
        while ((val = ref.get()) == null) {
            Class<T> clazz2 = clazz;
            synchronized (clazz2) {
                SoftReference<Object> newRef = MAP.get(clazz);
                if (newRef == ref) {
                    newRef = new SoftReference<T>(InstancePool.createInstance(clazz));
                    MAP.replace(clazz, ref, newRef);
                }
                ref = newRef;
            }
        }
        return val;
    }

    private static <T> T createInstance(@NonNull Class<T> clazz) {
        if (clazz == null) {
            throw new NullPointerException("clazz");
        }
        try {
            Constructor<T> constructor = clazz.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return constructor.newInstance(new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(clazz.getCanonicalName(), e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (InstantiationException | InvocationTargetException e) {
            throw new RuntimeException(clazz.getCanonicalName(), e);
        }
    }

    private InstancePool() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

