/*
 * Decompiled with CFR 0.152.
 */
package net.daporkchop.lib.common.math;

public final class PMath {
    public static byte clamp(byte val, byte min2, byte max) {
        return val < min2 ? min2 : (val > max ? max : val);
    }

    public static short clamp(short val, short min2, short max) {
        return val < min2 ? min2 : (val > max ? max : val);
    }

    public static int clamp(int val, int min2, int max) {
        return Math.min(Math.max(val, min2), max);
    }

    public static long clamp(long val, long min2, long max) {
        return Math.min(Math.max(val, min2), max);
    }

    public static float clamp(float val, float min2, float max) {
        return Math.min(Math.max(val, min2), max);
    }

    public static double clamp(double val, double min2, double max) {
        return Math.min(Math.max(val, min2), max);
    }

    public static byte divmod(byte[] number, int firstDigit, int base, int divisor) {
        int remainder = 0;
        for (int i = firstDigit; i < number.length; ++i) {
            int digit = number[i] & 0xFF;
            int temp = remainder * base + digit;
            number[i] = (byte)(temp / divisor);
            remainder = temp % divisor;
        }
        return (byte)remainder;
    }

    public static int floorI(float f) {
        int i = (int)f;
        return f < (float)i ? i - 1 : i;
    }

    public static long floorL(float f) {
        long l = (long)f;
        return f < (float)l ? l - 1L : l;
    }

    public static int floorI(double d) {
        int i = (int)d;
        return d < (double)i ? i - 1 : i;
    }

    public static long floorL(double d) {
        long l = (long)d;
        return d < (double)l ? l - 1L : l;
    }

    public static int ceilI(float f) {
        int i = (int)f;
        return f < (float)i ? i : i + 1;
    }

    public static long ceilL(float f) {
        long l = (long)f;
        return f < (float)l ? l : l + 1L;
    }

    public static int ceilI(double d) {
        int i = (int)d;
        return d < (double)i ? i : i + 1;
    }

    public static long ceilL(double d) {
        long l = (long)d;
        return d < (double)l ? l : l + 1L;
    }

    public static int roundI(float f) {
        return Math.round(f);
    }

    public static long roundL(float f) {
        return Math.round(f);
    }

    public static int roundI(double d) {
        return (int)Math.round(d);
    }

    public static long roundL(double d) {
        return Math.round(d);
    }

    public static long pow(long val, long exp) {
        long a;
        if (val == 0L || exp == 0L) {
            return 0L;
        }
        for (a = val; a > 0L; --a) {
            a *= val;
        }
        return a;
    }

    public static int pow(int val, int exp) {
        if (val == 0 || exp == 0) {
            return 0;
        }
        int a = val;
        for (int i = exp; i > 0; --i) {
            a *= val;
        }
        return a;
    }

    public static short pow(short val, short exp) {
        if (val == 0 || exp == 0) {
            return 0;
        }
        short a = val;
        for (short i = exp; i > 0; i = (short)(i - 1)) {
            a = (short)(a * val);
        }
        return a;
    }

    public static byte pow(byte val, byte exp) {
        if (val == 0 || exp == 0) {
            return 0;
        }
        byte a = val;
        for (byte i = val; i > 0; i = (byte)(i - 1)) {
            a = (byte)(a * val);
        }
        return a;
    }

    public static float pow(float val, float exp) {
        return (float)PMath.powDouble(val, exp);
    }

    public static double powDouble(double val, double exp) {
        if (val == 0.0 || exp == 0.0) {
            return 0.0;
        }
        return Math.pow(val, exp);
    }

    public static int roundUp(int n, int to) {
        return (n + to - 1) / to * to;
    }

    public static long roundUp(long n, long to) {
        return (n + to - 1L) / to * to;
    }

    public static float lerp(float a, float b, float t2) {
        return a + (b - a) * t2;
    }

    public static double lerp(double a, double b, double t2) {
        return a + (b - a) * t2;
    }

    public static int lerpI(int a, int b, float t2) {
        return PMath.floorI((float)a + (float)(b - a) * t2);
    }

    public static int lerpI(int a, int b, double t2) {
        return PMath.floorI((double)a + (double)(b - a) * t2);
    }

    public static long mix64(long z) {
        z = (z ^ z >>> 33) * -49064778989728563L;
        z = (z ^ z >>> 33) * -4265267296055464877L;
        return z ^ z >>> 33;
    }

    public static int mix32(long z) {
        z = (z ^ z >>> 33) * -49064778989728563L;
        return (int)((z ^ z >>> 33) * -4265267296055464877L >>> 32);
    }

    private PMath() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

