/*
 * Decompiled with CFR 0.152.
 */
package net.daporkchop.lib.common.math;

public final class BinMath {
    public static boolean isPow2(long value) {
        return value != 0L && (value & value - 1L) == 0L;
    }

    public static boolean isPow2(int value) {
        return value != 0 && (value & value - 1) == 0;
    }

    public static boolean isPow2(short value) {
        return value != 0 && (value & value - 1) == 0;
    }

    public static boolean isPow2(byte value) {
        return value != 0 && (value & value - 1) == 0;
    }

    public static int getNumBitsNeededFor(int value) {
        int count = 0;
        while (value > 0) {
            ++count;
            value >>= 1;
        }
        return count;
    }

    public static long roundToNearestPowerOf2(long value) {
        long l = value - 1L;
        l |= l >>> 1;
        l |= l >>> 2;
        l |= l >>> 4;
        l |= l >>> 8;
        l |= l >>> 16;
        l |= l >>> 32;
        return l + 1L;
    }

    public static int roundToNearestPowerOf2(int value) {
        int i = value - 1;
        i |= i >>> 1;
        i |= i >>> 2;
        i |= i >>> 4;
        i |= i >>> 8;
        i |= i >>> 16;
        return i + 1;
    }

    public static short roundToNearestPowerOf2(short value) {
        short s2 = (short)(value - 1);
        s2 = (short)(s2 | s2 >>> 1);
        s2 = (short)(s2 | s2 >>> 2);
        s2 = (short)(s2 | s2 >>> 4);
        s2 = (short)(s2 | s2 >>> 8);
        return (short)(s2 + 1);
    }

    public static int getFromFlags(int ... flags) {
        int i = 0;
        for (int flag : flags) {
            i |= 1 << flag;
        }
        return i;
    }

    public static int setFlag(int i, int flag) {
        return i | 1 << flag;
    }

    public static boolean getFlag(int i, int flag) {
        return (i & 1 << flag) != 0;
    }

    public static long packXY(int x, int y) {
        return Integer.toUnsignedLong(x) << 32 | Integer.toUnsignedLong(y);
    }

    public static int unpackX(long packed) {
        return (int)(packed >>> 32);
    }

    public static int unpackY(long packed) {
        return (int)packed;
    }

    private BinMath() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

