/*
 * Decompiled with CFR 0.152.
 */
package net.daporkchop.lib.common.function;

import java.lang.reflect.Constructor;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import lombok.NonNull;

public final class PFunctions {
    public static <T, R> Function<T, R> throwing(@NonNull Class<? extends Throwable> clazz) {
        if (clazz == null) {
            throw new NullPointerException("clazz");
        }
        try {
            Constructor<? extends Throwable> constructor = clazz.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return PFunctions.throwing(() -> (Throwable)constructor.newInstance(new Object[0]));
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T, R> Function<T, R> throwing(@NonNull Supplier<Throwable> supplier) {
        if (supplier == null) {
            throw new NullPointerException("supplier");
        }
        return t2 -> {
            throw new RuntimeException((Throwable)supplier.get());
        };
    }

    public static <T> Predicate<T> not(@NonNull Predicate<T> predicate) {
        if (predicate == null) {
            throw new NullPointerException("predicate");
        }
        return t2 -> !predicate.test(t2);
    }

    public static <T> Function<T, T> identity() {
        return o -> o;
    }

    private PFunctions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

