/*
 * Decompiled with CFR 0.152.
 */
package net.daporkchop.ldbjni.natives;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import lombok.NonNull;
import net.daporkchop.ldbjni.direct.DirectWriteBatch;
import net.daporkchop.ldbjni.natives.NativeDB;
import net.daporkchop.lib.common.util.PValidation;
import net.daporkchop.lib.unsafe.PCleaner;

final class NativeWriteBatch
implements DirectWriteBatch {
    final AtomicLong ptr;
    private final NativeDB db;
    private final PCleaner cleaner;

    public NativeWriteBatch(long ptr, @NonNull NativeDB db) {
        if (db == null) {
            throw new NullPointerException("db");
        }
        this.ptr = new AtomicLong(ptr);
        this.db = db;
        this.cleaner = PCleaner.cleaner((Object)this, new Releaser(this.ptr, this.db));
    }

    @Override
    public synchronized DirectWriteBatch put(@NonNull byte[] key, @NonNull byte[] value) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        this.put0HH(this.ptr.get(), key, 0, key.length, value, 0, value.length);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized DirectWriteBatch put(@NonNull ByteBuf key, @NonNull ByteBuf value) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        if (key.hasArray()) {
            if (value.hasArray()) {
                this.put0HH(this.ptr.get(), key.array(), key.arrayOffset() + key.readerIndex(), key.readableBytes(), value.array(), value.arrayOffset() + value.readerIndex(), value.readableBytes());
                return this;
            }
            if (value.hasMemoryAddress()) {
                this.put0HD(this.ptr.get(), key.array(), key.arrayOffset() + key.readerIndex(), key.readableBytes(), value.memoryAddress() + (long)value.readerIndex(), value.readableBytes());
                return this;
            }
        } else if (key.hasMemoryAddress()) {
            if (value.hasArray()) {
                this.put0DH(this.ptr.get(), key.memoryAddress() + (long)key.readerIndex(), key.readableBytes(), value.array(), value.arrayOffset() + value.readerIndex(), value.readableBytes());
                return this;
            }
            if (value.hasMemoryAddress()) {
                this.put0DD(this.ptr.get(), key.memoryAddress() + (long)key.readerIndex(), key.readableBytes(), value.memoryAddress() + (long)value.readerIndex(), value.readableBytes());
                return this;
            }
        }
        if (!key.hasArray() && !key.hasMemoryAddress()) {
            ByteBuf keyCopy = ByteBufAllocator.DEFAULT.buffer(key.readableBytes(), key.readableBytes());
            try {
                PValidation.checkState(keyCopy.hasArray() || keyCopy.hasMemoryAddress(), keyCopy);
                key.getBytes(key.readerIndex(), keyCopy);
                this.put(keyCopy, value);
            }
            finally {
                keyCopy.release();
            }
        } else if (!value.hasArray() && !value.hasMemoryAddress()) {
            ByteBuf valueCopy = ByteBufAllocator.DEFAULT.buffer(value.readableBytes(), value.readableBytes());
            try {
                PValidation.checkState(valueCopy.hasArray() || valueCopy.hasMemoryAddress(), valueCopy);
                value.getBytes(value.readerIndex(), valueCopy);
                this.put(key, valueCopy);
            }
            finally {
                valueCopy.release();
            }
        } else {
            throw new IllegalArgumentException(key + " " + value);
        }
        return this;
    }

    private native void put0HH(long var1, byte[] var3, int var4, int var5, byte[] var6, int var7, int var8);

    private native void put0HD(long var1, byte[] var3, int var4, int var5, long var6, int var8);

    private native void put0DH(long var1, long var3, int var5, byte[] var6, int var7, int var8);

    private native void put0DD(long var1, long var3, int var5, long var6, int var8);

    @Override
    public synchronized DirectWriteBatch delete(@NonNull byte[] key) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        this.delete0H(this.ptr.get(), key, 0, key.length);
        return this;
    }

    @Override
    public synchronized DirectWriteBatch delete(@NonNull ByteBuf key) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (key.hasArray()) {
            this.delete0H(this.ptr.get(), key.array(), key.arrayOffset() + key.readerIndex(), key.readableBytes());
        } else if (key.hasMemoryAddress()) {
            this.delete0D(this.ptr.get(), key.memoryAddress() + (long)key.readerIndex(), key.readableBytes());
        } else {
            ByteBuf keyCopy = ByteBufAllocator.DEFAULT.buffer(key.readableBytes(), key.readableBytes());
            try {
                PValidation.checkState(keyCopy.hasArray() || keyCopy.hasMemoryAddress(), keyCopy);
                key.getBytes(key.readerIndex(), keyCopy);
                this.delete(keyCopy);
            }
            finally {
                keyCopy.release();
            }
        }
        return this;
    }

    private native void delete0H(long var1, byte[] var3, int var4, int var5);

    private native void delete0D(long var1, long var3, int var5);

    @Override
    public synchronized void close() throws IOException {
        this.cleaner.clean();
    }

    public NativeWriteBatch(AtomicLong ptr, NativeDB db, PCleaner cleaner) {
        this.ptr = ptr;
        this.db = db;
        this.cleaner = cleaner;
    }

    private static final class Releaser
    implements Runnable {
        @NonNull
        private final AtomicLong ptr;
        @NonNull
        private final NativeDB db;

        @Override
        public void run() {
            this.db.releaseWriteBatch0(this.ptr.getAndSet(0L));
        }

        public Releaser(@NonNull AtomicLong ptr, @NonNull NativeDB db) {
            if (ptr == null) {
                throw new NullPointerException("ptr");
            }
            if (db == null) {
                throw new NullPointerException("db");
            }
            this.ptr = ptr;
            this.db = db;
        }
    }
}

