/*
 * Decompiled with CFR 0.152.
 */
package net.daporkchop.ldbjni.natives;

import java.io.File;
import java.io.IOException;
import lombok.NonNull;
import net.daporkchop.ldbjni.DBProvider;
import net.daporkchop.ldbjni.direct.DirectDB;
import net.daporkchop.ldbjni.natives.NativeDB;
import net.daporkchop.lib.common.misc.file.PFiles;
import org.iq80.leveldb.DB;
import org.iq80.leveldb.Options;
import org.iq80.leveldb.impl.Iq80DBFactory;

final class NativeDBProvider
implements DBProvider {
    NativeDBProvider() {
    }

    private static native void destroy0(String var0, boolean var1, boolean var2, boolean var3, int var4, int var5, int var6, int var7, int var8, int var9, long var10) throws IOException;

    private static native void repair0(String var0, boolean var1, boolean var2, boolean var3, int var4, int var5, int var6, int var7, int var8, int var9, long var10) throws IOException;

    @Override
    public boolean isNative() {
        return true;
    }

    @Override
    public DirectDB open(@NonNull File file, Options options) throws IOException {
        File fixedFile;
        if (file == null) {
            throw new NullPointerException("file");
        }
        if (PFiles.checkDirectoryExists(file) && PFiles.checkFileExists(new File(file, "CURRENT")) && !PFiles.checkFileExists(fixedFile = new File(file, "FIXED_MANIFEST"))) {
            DB db = Iq80DBFactory.factory.open(file, options);
            Throwable throwable = null;
            if (db != null) {
                if (throwable != null) {
                    try {
                        db.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    db.close();
                }
            }
            PFiles.ensureFileExists(fixedFile);
        }
        return new NativeDB(file, options);
    }

    @Override
    public void destroy(@NonNull File file, Options options) throws IOException {
        if (file == null) {
            throw new NullPointerException("file");
        }
        NativeDBProvider.destroy0(file.getAbsoluteFile().getAbsolutePath(), options.createIfMissing(), options.errorIfExists(), options.paranoidChecks(), options.writeBufferSize(), options.maxOpenFiles(), options.blockSize(), options.blockRestartInterval(), -1, options.compressionType().persistentId(), options.cacheSize());
    }

    @Override
    public void repair(@NonNull File file, Options options) throws IOException {
        if (file == null) {
            throw new NullPointerException("file");
        }
        NativeDBProvider.repair0(file.getAbsoluteFile().getAbsolutePath(), options.createIfMissing(), options.errorIfExists(), options.paranoidChecks(), options.writeBufferSize(), options.maxOpenFiles(), options.blockSize(), options.blockRestartInterval(), -1, options.compressionType().persistentId(), options.cacheSize());
    }
}

