/*
 * Decompiled with CFR 0.152.
 */
package net.daporkchop.ldbjni.natives;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.buffer.UnpooledUnsafeDirectByteBuf;
import io.netty.util.internal.PlatformDependent;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import lombok.NonNull;
import net.daporkchop.ldbjni.direct.BufType;
import net.daporkchop.ldbjni.direct.DirectDB;
import net.daporkchop.ldbjni.direct.DirectReadOptions;
import net.daporkchop.ldbjni.direct.DirectWriteBatch;
import net.daporkchop.ldbjni.natives.NativeWriteBatch;
import net.daporkchop.lib.common.util.PValidation;
import net.daporkchop.lib.unsafe.PCleaner;
import net.daporkchop.lib.unsafe.PUnsafe;
import org.iq80.leveldb.DBException;
import org.iq80.leveldb.DBIterator;
import org.iq80.leveldb.Options;
import org.iq80.leveldb.Range;
import org.iq80.leveldb.ReadOptions;
import org.iq80.leveldb.Snapshot;
import org.iq80.leveldb.WriteBatch;
import org.iq80.leveldb.WriteOptions;

final class NativeDB
implements DirectDB {
    private static final ReadOptions DEFAULT_READ_OPTIONS = new ReadOptions();
    private static final WriteOptions DEFAULT_WRITE_OPTIONS = new WriteOptions();
    private static final long CLEANER_OFFSET = PUnsafe.pork_getOffset(ByteBuffer.allocateDirect(0).getClass(), "cleaner");
    private long db;
    private long dca;
    private final PCleaner cleaner;
    private final Lock readLock;
    private final Lock writeLock;

    private static native void init();

    private static native long openDb(String var0, boolean var1, boolean var2, boolean var3, int var4, int var5, int var6, int var7, int var8, int var9, long var10);

    private static native long createDecompressAllocator();

    private static native void closeDb(long var0, long var2);

    private static native void deleteString(long var0);

    public NativeDB(@NonNull File path, @NonNull Options options) {
        if (path == null) {
            throw new NullPointerException("path");
        }
        if (options == null) {
            throw new NullPointerException("options");
        }
        if (options.comparator() != null) {
            throw new UnsupportedOperationException("comparator");
        }
        if (options.compressionType() == null) {
            throw new NullPointerException("compressionType");
        }
        this.db = NativeDB.openDb(path.getAbsoluteFile().getAbsolutePath(), options.createIfMissing(), options.errorIfExists(), options.paranoidChecks(), options.writeBufferSize(), options.maxOpenFiles(), options.blockSize(), options.blockRestartInterval(), -1, options.compressionType().persistentId(), options.cacheSize());
        this.dca = NativeDB.createDecompressAllocator();
        this.cleaner = PCleaner.cleaner((Object)this, new Releaser(this.db, this.dca));
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
    }

    @Override
    public byte[] get(@NonNull byte[] key) throws DBException {
        if (key == null) {
            throw new NullPointerException("key");
        }
        return this.get(key, DEFAULT_READ_OPTIONS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] get(@NonNull byte[] key, @NonNull ReadOptions options) throws DBException {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (options == null) {
            throw new NullPointerException("options");
        }
        this.readLock.lock();
        try {
            this.assertOpen();
            byte[] byArray = this.get0(key, options.verifyChecksums(), options.fillCache(), 0L);
            return byArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private native byte[] get0(byte[] var1, boolean var2, boolean var3, long var4);

    @Override
    public void put(@NonNull byte[] key, @NonNull byte[] value) throws DBException {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        this.put(key, value, DEFAULT_WRITE_OPTIONS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Snapshot put(@NonNull byte[] key, @NonNull byte[] value, @NonNull WriteOptions options) throws DBException {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        if (options == null) {
            throw new NullPointerException("options");
        }
        if (options.snapshot()) {
            throw new UnsupportedOperationException("snapshot");
        }
        this.readLock.lock();
        try {
            this.assertOpen();
            this.put0HH(key, 0, key.length, value, 0, value.length, options.sync());
            Snapshot snapshot = null;
            return snapshot;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void delete(@NonNull byte[] key) throws DBException {
        if (key == null) {
            throw new NullPointerException("key");
        }
        this.delete(key, DEFAULT_WRITE_OPTIONS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Snapshot delete(@NonNull byte[] key, @NonNull WriteOptions options) throws DBException {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (options == null) {
            throw new NullPointerException("options");
        }
        if (options.snapshot()) {
            throw new UnsupportedOperationException("snapshot");
        }
        this.readLock.lock();
        try {
            this.assertOpen();
            this.delete0H(key, 0, key.length, options.sync());
            Snapshot snapshot = null;
            return snapshot;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public DirectWriteBatch createWriteBatch() {
        return new NativeWriteBatch(this.createWriteBatch0(), this);
    }

    private native long createWriteBatch0();

    native void releaseWriteBatch0(long var1);

    @Override
    public void write(@NonNull WriteBatch writeBatch) throws DBException {
        if (writeBatch == null) {
            throw new NullPointerException("writeBatch");
        }
        this.write(writeBatch, DEFAULT_WRITE_OPTIONS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Snapshot write(@NonNull WriteBatch writeBatch, @NonNull WriteOptions options) throws DBException {
        if (writeBatch == null) {
            throw new NullPointerException("writeBatch");
        }
        if (options == null) {
            throw new NullPointerException("options");
        }
        if (!(writeBatch instanceof NativeWriteBatch)) {
            throw new IllegalArgumentException(writeBatch.getClass().getCanonicalName());
        }
        if (options.snapshot()) {
            throw new UnsupportedOperationException("snapshot");
        }
        this.readLock.lock();
        try {
            this.assertOpen();
            WriteBatch writeBatch2 = writeBatch;
            synchronized (writeBatch2) {
                this.writeBatch0(((NativeWriteBatch)writeBatch).ptr.get(), options.sync());
            }
            writeBatch2 = null;
            return writeBatch2;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private native void writeBatch0(long var1, boolean var3);

    @Override
    public DBIterator iterator() {
        throw new UnsupportedOperationException("iterator");
    }

    @Override
    public DBIterator iterator(@NonNull ReadOptions options) {
        if (options == null) {
            throw new NullPointerException("options");
        }
        throw new UnsupportedOperationException("iterator");
    }

    @Override
    public Snapshot getSnapshot() {
        throw new UnsupportedOperationException("getSnapshot");
    }

    @Override
    public long[] getApproximateSizes(Range ... ranges) {
        if (ranges == null) {
            throw new NullPointerException("ranges");
        }
        throw new UnsupportedOperationException("getApproximateSizes");
    }

    @Override
    public String getProperty(@NonNull String s2) {
        if (s2 == null) {
            throw new NullPointerException("s");
        }
        throw new UnsupportedOperationException("getProperty");
    }

    @Override
    public void suspendCompactions() throws InterruptedException {
        throw new UnsupportedOperationException("suspendCompactions");
    }

    @Override
    public void resumeCompactions() {
        throw new UnsupportedOperationException("resumeCompactions");
    }

    @Override
    public void compactRange(byte[] start, byte[] limit) throws DBException {
        this.readLock.lock();
        try {
            this.assertOpen();
            this.compactRange0(start, limit);
        }
        finally {
            this.readLock.unlock();
        }
    }

    private native void compactRange0(byte[] var1, byte[] var2);

    @Override
    public void close() throws IOException {
        if (this.cleaner.hasRun()) {
            return;
        }
        this.writeLock.lock();
        try {
            if (!this.cleaner.hasRun()) {
                this.cleaner.clean();
                this.dca = 0L;
                this.db = 0L;
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private ByteBufAllocator selectAlloc(@NonNull ReadOptions options) {
        if (options == null) {
            throw new NullPointerException("options");
        }
        ByteBufAllocator alloc = options instanceof DirectReadOptions ? ((DirectReadOptions)options).alloc() : null;
        return alloc == null ? ByteBufAllocator.DEFAULT : alloc;
    }

    private BufType selectType(@NonNull ReadOptions options) {
        if (options == null) {
            throw new NullPointerException("options");
        }
        BufType type = options instanceof DirectReadOptions ? ((DirectReadOptions)options).type() : null;
        return type == null ? BufType.DEFAULT : type;
    }

    @Override
    public ByteBuf get(@NonNull ByteBuf key) throws DBException {
        if (key == null) {
            throw new NullPointerException("key");
        }
        return this.get(key, DEFAULT_READ_OPTIONS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuf get(@NonNull ByteBuf key, @NonNull ReadOptions options) throws DBException {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (options == null) {
            throw new NullPointerException("options");
        }
        this.readLock.lock();
        try {
            ByteBuf byteBuf;
            this.assertOpen();
            if (key.hasArray()) {
                ByteBuf byteBuf2 = this.get0H(key.array(), key.arrayOffset() + key.readerIndex(), key.readableBytes(), options.verifyChecksums(), options.fillCache(), 0L, this.selectAlloc(options), this.selectType(options));
                return byteBuf2;
            }
            if (key.hasMemoryAddress()) {
                ByteBuf byteBuf3 = this.get0D(key.memoryAddress() + (long)key.readerIndex(), key.readableBytes(), options.verifyChecksums(), options.fillCache(), 0L, this.selectAlloc(options), this.selectType(options));
                return byteBuf3;
            }
            ByteBuf keyCopy = this.selectAlloc(options).ioBuffer(key.readableBytes(), key.readableBytes());
            try {
                PValidation.checkState(keyCopy.hasArray() || keyCopy.hasMemoryAddress(), keyCopy);
                key.getBytes(key.readerIndex(), keyCopy);
                byteBuf = this.get(keyCopy, options);
            }
            catch (Throwable throwable) {
                keyCopy.release();
                throw throwable;
            }
            keyCopy.release();
            return byteBuf;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private native ByteBuf get0H(byte[] var1, int var2, int var3, boolean var4, boolean var5, long var6, ByteBufAllocator var8, BufType var9);

    private native ByteBuf get0D(long var1, int var3, boolean var4, boolean var5, long var6, ByteBufAllocator var8, BufType var9);

    private ByteBuf get0_final(long valueAddr, int valueLen, @NonNull ByteBufAllocator alloc, @NonNull BufType type) {
        if (alloc == null) {
            throw new NullPointerException("alloc");
        }
        if (type == null) {
            throw new NullPointerException("type");
        }
        return type.allocate(alloc, valueLen).writeBytes(Unpooled.wrappedBuffer(valueAddr, valueLen, false));
    }

    @Override
    public boolean getInto(@NonNull ByteBuf key, @NonNull ByteBuf dst) throws DBException {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (dst == null) {
            throw new NullPointerException("dst");
        }
        return this.getInto(key, dst, DEFAULT_READ_OPTIONS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getInto(@NonNull ByteBuf key, @NonNull ByteBuf dst, @NonNull ReadOptions options) throws DBException {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (dst == null) {
            throw new NullPointerException("dst");
        }
        if (options == null) {
            throw new NullPointerException("options");
        }
        this.readLock.lock();
        try {
            boolean bl;
            this.assertOpen();
            if (key.hasArray()) {
                boolean bl2 = this.getInto0H(key.array(), key.arrayOffset() + key.readerIndex(), key.readableBytes(), options.verifyChecksums(), options.fillCache(), 0L, dst);
                return bl2;
            }
            if (key.hasMemoryAddress()) {
                boolean bl3 = this.getInto0D(key.memoryAddress() + (long)key.readerIndex(), key.readableBytes(), options.verifyChecksums(), options.fillCache(), 0L, dst);
                return bl3;
            }
            ByteBuf keyCopy = this.selectAlloc(options).ioBuffer(key.readableBytes(), key.readableBytes());
            try {
                PValidation.checkState(keyCopy.hasArray() || keyCopy.hasMemoryAddress(), keyCopy);
                key.getBytes(key.readerIndex(), keyCopy);
                bl = this.getInto(keyCopy, dst, options);
            }
            catch (Throwable throwable) {
                keyCopy.release();
                throw throwable;
            }
            keyCopy.release();
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private native boolean getInto0H(byte[] var1, int var2, int var3, boolean var4, boolean var5, long var6, ByteBuf var8);

    private native boolean getInto0D(long var1, int var3, boolean var4, boolean var5, long var6, ByteBuf var8);

    private void getInto0_final(long valueAddr, int valueLen, @NonNull ByteBuf dst) {
        if (dst == null) {
            throw new NullPointerException("dst");
        }
        dst.writeBytes(Unpooled.wrappedBuffer(valueAddr, valueLen, false));
    }

    @Override
    public ByteBuf getZeroCopy(@NonNull ByteBuf key) throws DBException {
        if (key == null) {
            throw new NullPointerException("key");
        }
        return this.getZeroCopy(key, DEFAULT_READ_OPTIONS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuf getZeroCopy(@NonNull ByteBuf key, @NonNull ReadOptions options) throws DBException {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (options == null) {
            throw new NullPointerException("options");
        }
        this.readLock.lock();
        try {
            ByteBuf byteBuf;
            this.assertOpen();
            if (key.hasArray()) {
                ByteBuf byteBuf2 = this.getZeroCopy0H(key.array(), key.arrayOffset() + key.readerIndex(), key.readableBytes(), options.verifyChecksums(), options.fillCache(), 0L);
                return byteBuf2;
            }
            if (key.hasMemoryAddress()) {
                ByteBuf byteBuf3 = this.getZeroCopy0D(key.memoryAddress() + (long)key.readerIndex(), key.readableBytes(), options.verifyChecksums(), options.fillCache(), 0L);
                return byteBuf3;
            }
            ByteBuf keyCopy = this.selectAlloc(options).ioBuffer(key.readableBytes(), key.readableBytes());
            try {
                PValidation.checkState(keyCopy.hasArray() || keyCopy.hasMemoryAddress(), keyCopy);
                key.getBytes(key.readerIndex(), keyCopy);
                byteBuf = this.getZeroCopy(keyCopy, options);
            }
            catch (Throwable throwable) {
                keyCopy.release();
                throw throwable;
            }
            keyCopy.release();
            return byteBuf;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private native ByteBuf getZeroCopy0H(byte[] var1, int var2, int var3, boolean var4, boolean var5, long var6);

    private native ByteBuf getZeroCopy0D(long var1, int var3, boolean var4, boolean var5, long var6);

    private ByteBuf getZeroCopy0_final(long valueAddr, int valueLen, long strAddr) {
        return new StdStringByteBuf(valueAddr, valueLen, strAddr);
    }

    @Override
    public void put(@NonNull ByteBuf key, @NonNull ByteBuf value) throws DBException {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        this.put(key, value, DEFAULT_WRITE_OPTIONS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Snapshot put(@NonNull ByteBuf key, @NonNull ByteBuf value, @NonNull WriteOptions options) throws DBException {
        block27: {
            if (key == null) {
                throw new NullPointerException("key");
            }
            if (value == null) {
                throw new NullPointerException("value");
            }
            if (options == null) {
                throw new NullPointerException("options");
            }
            if (options.snapshot()) {
                throw new UnsupportedOperationException("snapshot");
            }
            this.readLock.lock();
            this.assertOpen();
            if (key.hasArray()) {
                if (value.hasArray()) {
                    this.put0HH(key.array(), key.arrayOffset() + key.readerIndex(), key.readableBytes(), value.array(), value.arrayOffset() + value.readerIndex(), value.readableBytes(), options.sync());
                    Snapshot snapshot = null;
                    return snapshot;
                }
                if (value.hasMemoryAddress()) {
                    this.put0HD(key.array(), key.arrayOffset() + key.readerIndex(), key.readableBytes(), value.memoryAddress() + (long)value.readerIndex(), value.readableBytes(), options.sync());
                    Snapshot snapshot = null;
                    return snapshot;
                }
            } else if (key.hasMemoryAddress()) {
                if (value.hasArray()) {
                    this.put0DH(key.memoryAddress() + (long)key.readerIndex(), key.readableBytes(), value.array(), value.arrayOffset() + value.readerIndex(), value.readableBytes(), options.sync());
                    Snapshot snapshot = null;
                    return snapshot;
                }
                if (value.hasMemoryAddress()) {
                    this.put0DD(key.memoryAddress() + (long)key.readerIndex(), key.readableBytes(), value.memoryAddress() + (long)value.readerIndex(), value.readableBytes(), options.sync());
                    Snapshot snapshot = null;
                    return snapshot;
                }
            }
            if (!key.hasArray() && !key.hasMemoryAddress()) {
                ByteBuf keyCopy = ByteBufAllocator.DEFAULT.buffer(key.readableBytes(), key.readableBytes());
                try {
                    PValidation.checkState(keyCopy.hasArray() || keyCopy.hasMemoryAddress(), keyCopy);
                    key.getBytes(key.readerIndex(), keyCopy);
                    Snapshot snapshot = this.put(keyCopy, value, options);
                    return snapshot;
                }
                finally {
                    keyCopy.release();
                }
            }
            if (value.hasArray() || value.hasMemoryAddress()) break block27;
            ByteBuf valueCopy = ByteBufAllocator.DEFAULT.buffer(value.readableBytes(), value.readableBytes());
            try {
                PValidation.checkState(valueCopy.hasArray() || valueCopy.hasMemoryAddress(), valueCopy);
                value.getBytes(value.readerIndex(), valueCopy);
                Snapshot snapshot = this.put(key, valueCopy, options);
                return snapshot;
            }
            finally {
                valueCopy.release();
            }
        }
        throw new IllegalArgumentException(key + " " + value);
        finally {
            this.readLock.unlock();
        }
    }

    private native void put0HH(byte[] var1, int var2, int var3, byte[] var4, int var5, int var6, boolean var7);

    private native void put0HD(byte[] var1, int var2, int var3, long var4, int var6, boolean var7);

    private native void put0DH(long var1, int var3, byte[] var4, int var5, int var6, boolean var7);

    private native void put0DD(long var1, int var3, long var4, int var6, boolean var7);

    @Override
    public void delete(@NonNull ByteBuf key) throws DBException {
        if (key == null) {
            throw new NullPointerException("key");
        }
        this.delete(key, DEFAULT_WRITE_OPTIONS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Snapshot delete(@NonNull ByteBuf key, @NonNull WriteOptions options) throws DBException {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (options == null) {
            throw new NullPointerException("options");
        }
        if (options.snapshot()) {
            throw new UnsupportedOperationException("snapshot");
        }
        this.readLock.lock();
        try {
            this.assertOpen();
            if (key.hasArray()) {
                this.delete0H(key.array(), key.arrayOffset() + key.readerIndex(), key.readableBytes(), options.sync());
            } else if (key.hasMemoryAddress()) {
                this.delete0D(key.memoryAddress() + (long)key.readerIndex(), key.readableBytes(), options.sync());
            } else {
                ByteBuf keyCopy = ByteBufAllocator.DEFAULT.buffer(key.readableBytes(), key.readableBytes());
                try {
                    PValidation.checkState(keyCopy.hasArray() || keyCopy.hasMemoryAddress(), keyCopy);
                    key.getBytes(key.readerIndex(), keyCopy);
                    Snapshot snapshot = this.delete(keyCopy, options);
                    return snapshot;
                }
                finally {
                    keyCopy.release();
                }
            }
            Snapshot snapshot = null;
            return snapshot;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private native void delete0H(byte[] var1, int var2, int var3, boolean var4);

    private native void delete0D(long var1, int var3, boolean var4);

    private void assertOpen() {
        if (this.db == 0L) {
            throw new IllegalStateException("NativeDB already closed!");
        }
    }

    static {
        NativeDB.init();
    }

    private static final class StdStringByteBuf
    extends UnpooledUnsafeDirectByteBuf {
        protected final long strAddr;

        public StdStringByteBuf(long valueAddr, int valueLen, long strAddr) {
            super((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, PlatformDependent.directBuffer(valueAddr, valueLen), valueLen);
            this.strAddr = strAddr;
        }

        @Override
        protected void freeDirect(ByteBuffer buffer) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ByteBuf capacity(int newCapacity) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void deallocate() {
            NativeDB.deleteString(this.strAddr);
        }
    }

    private static final class Releaser
    implements Runnable {
        private final long db;
        private final long dca;

        @Override
        public void run() {
            NativeDB.closeDb(this.db, this.dca);
        }

        public Releaser(long db, long dca) {
            this.db = db;
            this.dca = dca;
        }
    }
}

