/*
 * Decompiled with CFR 0.152.
 */
package net.daporkchop.ldbjni.java;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import lombok.NonNull;
import net.daporkchop.ldbjni.direct.DirectDB;
import net.daporkchop.ldbjni.direct.DirectWriteBatch;
import net.daporkchop.ldbjni.java.JavaDirectWriteBatchWrapper;
import org.iq80.leveldb.DB;
import org.iq80.leveldb.DBException;
import org.iq80.leveldb.DBIterator;
import org.iq80.leveldb.Range;
import org.iq80.leveldb.ReadOptions;
import org.iq80.leveldb.Snapshot;
import org.iq80.leveldb.WriteBatch;
import org.iq80.leveldb.WriteOptions;

final class JavaDirectDBWrapper
implements DirectDB {
    @NonNull
    protected final DB delegate;

    static byte[] toArray(@NonNull ByteBuf buf) {
        if (buf == null) {
            throw new NullPointerException("buf");
        }
        byte[] arr = new byte[buf.readableBytes()];
        buf.getBytes(buf.readerIndex(), arr);
        return arr;
    }

    @Override
    public byte[] get(@NonNull byte[] key) throws DBException {
        if (key == null) {
            throw new NullPointerException("key");
        }
        return this.delegate.get(key);
    }

    @Override
    public ByteBuf get(@NonNull ByteBuf key) throws DBException {
        if (key == null) {
            throw new NullPointerException("key");
        }
        byte[] val = this.get(JavaDirectDBWrapper.toArray(key));
        return val != null ? Unpooled.wrappedBuffer(val) : null;
    }

    @Override
    public byte[] get(@NonNull byte[] key, @NonNull ReadOptions options) throws DBException {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (options == null) {
            throw new NullPointerException("options");
        }
        return this.delegate.get(key, options);
    }

    @Override
    public ByteBuf get(@NonNull ByteBuf key, @NonNull ReadOptions options) throws DBException {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (options == null) {
            throw new NullPointerException("options");
        }
        byte[] val = this.get(JavaDirectDBWrapper.toArray(key), options);
        return val != null ? Unpooled.wrappedBuffer(val) : null;
    }

    @Override
    public boolean getInto(@NonNull ByteBuf key, @NonNull ByteBuf dst) throws DBException {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (dst == null) {
            throw new NullPointerException("dst");
        }
        byte[] val = this.get(JavaDirectDBWrapper.toArray(key));
        if (val != null) {
            dst.writeBytes(val);
            return true;
        }
        return false;
    }

    @Override
    public boolean getInto(@NonNull ByteBuf key, @NonNull ByteBuf dst, @NonNull ReadOptions options) throws DBException {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (dst == null) {
            throw new NullPointerException("dst");
        }
        if (options == null) {
            throw new NullPointerException("options");
        }
        byte[] val = this.get(JavaDirectDBWrapper.toArray(key), options);
        if (val != null) {
            dst.writeBytes(val);
            return true;
        }
        return false;
    }

    @Override
    public void put(@NonNull byte[] key, @NonNull byte[] value) throws DBException {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        this.delegate.put(key, value);
    }

    @Override
    public void put(@NonNull ByteBuf key, @NonNull ByteBuf value) throws DBException {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        this.put(JavaDirectDBWrapper.toArray(key), JavaDirectDBWrapper.toArray(value));
    }

    @Override
    public Snapshot put(@NonNull byte[] key, @NonNull byte[] value, @NonNull WriteOptions options) throws DBException {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        if (options == null) {
            throw new NullPointerException("options");
        }
        return this.delegate.put(key, value, options);
    }

    @Override
    public Snapshot put(@NonNull ByteBuf key, @NonNull ByteBuf value, @NonNull WriteOptions options) throws DBException {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        if (options == null) {
            throw new NullPointerException("options");
        }
        return this.put(JavaDirectDBWrapper.toArray(key), JavaDirectDBWrapper.toArray(value), options);
    }

    @Override
    public void delete(@NonNull byte[] key) throws DBException {
        if (key == null) {
            throw new NullPointerException("key");
        }
        this.delegate.delete(key);
    }

    @Override
    public void delete(@NonNull ByteBuf key) throws DBException {
        if (key == null) {
            throw new NullPointerException("key");
        }
        this.delete(JavaDirectDBWrapper.toArray(key));
    }

    @Override
    public Snapshot delete(@NonNull byte[] key, @NonNull WriteOptions options) throws DBException {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (options == null) {
            throw new NullPointerException("options");
        }
        return this.delegate.delete(key, options);
    }

    @Override
    public Snapshot delete(@NonNull ByteBuf key, @NonNull WriteOptions options) throws DBException {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (options == null) {
            throw new NullPointerException("options");
        }
        return this.delete(JavaDirectDBWrapper.toArray(key), options);
    }

    @Override
    public DBIterator iterator() {
        return this.delegate.iterator();
    }

    @Override
    public DBIterator iterator(@NonNull ReadOptions options) {
        if (options == null) {
            throw new NullPointerException("options");
        }
        return this.delegate.iterator(options);
    }

    @Override
    public DirectWriteBatch createWriteBatch() {
        return new JavaDirectWriteBatchWrapper(this.delegate.createWriteBatch());
    }

    @Override
    public void write(@NonNull WriteBatch writeBatch) throws DBException {
        if (writeBatch == null) {
            throw new NullPointerException("writeBatch");
        }
        this.delegate.write(writeBatch instanceof JavaDirectWriteBatchWrapper ? ((JavaDirectWriteBatchWrapper)writeBatch).delegate : writeBatch);
    }

    @Override
    public Snapshot write(@NonNull WriteBatch writeBatch, @NonNull WriteOptions options) throws DBException {
        if (writeBatch == null) {
            throw new NullPointerException("writeBatch");
        }
        if (options == null) {
            throw new NullPointerException("options");
        }
        return this.delegate.write(writeBatch instanceof JavaDirectWriteBatchWrapper ? ((JavaDirectWriteBatchWrapper)writeBatch).delegate : writeBatch, options);
    }

    @Override
    public long[] getApproximateSizes(Range ... ranges) {
        if (ranges == null) {
            throw new NullPointerException("ranges");
        }
        return this.delegate.getApproximateSizes(ranges);
    }

    @Override
    public String getProperty(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        return this.delegate.getProperty(name);
    }

    @Override
    public Snapshot getSnapshot() {
        return this.delegate.getSnapshot();
    }

    @Override
    public void compactRange(byte[] begin, byte[] end) throws DBException {
        this.delegate.compactRange(begin, end);
    }

    @Override
    public void suspendCompactions() throws InterruptedException {
        this.delegate.suspendCompactions();
    }

    @Override
    public void resumeCompactions() {
        this.delegate.resumeCompactions();
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    public JavaDirectDBWrapper(@NonNull DB delegate) {
        if (delegate == null) {
            throw new NullPointerException("delegate");
        }
        this.delegate = delegate;
    }
}

