/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.utils.material.tags;

import cn.nukkit.item.RuntimeItems;
import cn.nukkit.utils.Utils;
import cn.nukkit.utils.material.tags.LazilyInitializedMaterialTag;
import cn.nukkit.utils.material.tags.MaterialTag;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MaterialTags {
    @Generated
    private static final Logger log = LogManager.getLogger(MaterialTags.class);
    private static final Map<String, MaterialTag> tags = new HashMap<String, MaterialTag>();
    private static final Map<String, Set<String>> vanillaTagDefinitions = new HashMap<String, Set<String>>();
    public static final MaterialTag ARROW;
    public static final MaterialTag BANNER;
    public static final MaterialTag BOAT;
    public static final MaterialTag BOATS;
    public static final MaterialTag BOOKSHELF_BOOKS;
    public static final MaterialTag CHAINMAIL_TIER;
    public static final MaterialTag COALS;
    public static final MaterialTag CRIMSON_STEMS;
    public static final MaterialTag DECORATED_POT_SHERDS;
    public static final MaterialTag DIAMOND_TIER;
    public static final MaterialTag DIGGER;
    public static final MaterialTag DOOR;
    public static final MaterialTag GOLDEN_TIER;
    public static final MaterialTag HANGING_ACTOR;
    public static final MaterialTag HANGING_SIGN;
    public static final MaterialTag HORSE_ARMOR;
    public static final MaterialTag IRON_TIER;
    public static final MaterialTag IS_ARMOR;
    public static final MaterialTag IS_AXE;
    public static final MaterialTag IS_COOKED;
    public static final MaterialTag IS_FISH;
    public static final MaterialTag IS_FOOD;
    public static final MaterialTag IS_HOE;
    public static final MaterialTag IS_MEAT;
    public static final MaterialTag IS_MINECART;
    public static final MaterialTag IS_PICKAXE;
    public static final MaterialTag IS_SHOVEL;
    public static final MaterialTag IS_SWORD;
    public static final MaterialTag IS_TOOL;
    public static final MaterialTag IS_TRIDENT;
    public static final MaterialTag LEATHER_TIER;
    public static final MaterialTag LECTERN_BOOKS;
    public static final MaterialTag LOGS;
    public static final MaterialTag LOGS_THAT_BURN;
    public static final MaterialTag MANGROVE_LOGS;
    public static final MaterialTag MUSIC_DISC;
    public static final MaterialTag NETHERITE_TIER;
    public static final MaterialTag PLANKS;
    public static final MaterialTag SAND;
    public static final MaterialTag SIGN;
    public static final MaterialTag SOUL_FIRE_BASE_BLOCKS;
    public static final MaterialTag SPAWN_EGG;
    public static final MaterialTag STONE_BRICKS;
    public static final MaterialTag STONE_CRAFTING_MATERIALS;
    public static final MaterialTag STONE_TIER;
    public static final MaterialTag STONE_TOOL_MATERIALS;
    public static final MaterialTag TRANSFORM_MATERIALS;
    public static final MaterialTag TRANSFORM_TEMPLATES;
    public static final MaterialTag TRANSFORMABLE_ITEMS;
    public static final MaterialTag TRIM_MATERIALS;
    public static final MaterialTag TRIM_TEMPLATES;
    public static final MaterialTag TRIMMABLE_ARMORS;
    public static final MaterialTag VIBRATION_DAMPER;
    public static final MaterialTag WARPED_STEMS;
    public static final MaterialTag WOODEN_SLABS;
    public static final MaterialTag WOODEN_TIER;
    public static final MaterialTag WOOL;

    public static MaterialTag register(String tagName, MaterialTag tag) {
        if (tags.containsKey(tagName)) {
            throw new IllegalArgumentException("Tag " + tagName + " is already registered");
        }
        tags.put(tagName, tag);
        return tag;
    }

    public static MaterialTag get(String tag) {
        return tags.get(tag);
    }

    protected static Set<String> getVanillaDefinitions(String tag) {
        return vanillaTagDefinitions.get(tag);
    }

    static {
        JsonObject json = Utils.loadJsonResource("item_tags.json").getAsJsonObject();
        for (Map.Entry<String, JsonElement> entry : json.entrySet()) {
            Set materials = vanillaTagDefinitions.computeIfAbsent(entry.getKey(), key -> new ObjectOpenHashSet());
            for (JsonElement element : entry.getValue().getAsJsonArray()) {
                String identifier = element.getAsString();
                String legacyName = RuntimeItems.getLegacyStringFromNew(identifier);
                if (legacyName == null) {
                    log.warn("No legacy name for " + identifier);
                    continue;
                }
                materials.add(legacyName);
            }
        }
        ARROW = MaterialTags.register("minecraft:arrow", new LazilyInitializedMaterialTag("minecraft:arrow"));
        BANNER = MaterialTags.register("minecraft:banner", new LazilyInitializedMaterialTag("minecraft:banner"));
        BOAT = MaterialTags.register("minecraft:boat", new LazilyInitializedMaterialTag("minecraft:boat"));
        BOATS = MaterialTags.register("minecraft:boats", new LazilyInitializedMaterialTag("minecraft:boats"));
        BOOKSHELF_BOOKS = MaterialTags.register("minecraft:bookshelf_books", new LazilyInitializedMaterialTag("minecraft:bookshelf_books"));
        CHAINMAIL_TIER = MaterialTags.register("minecraft:chainmail_tier", new LazilyInitializedMaterialTag("minecraft:chainmail_tier"));
        COALS = MaterialTags.register("minecraft:coals", new LazilyInitializedMaterialTag("minecraft:coals"));
        CRIMSON_STEMS = MaterialTags.register("minecraft:crimson_stems", new LazilyInitializedMaterialTag("minecraft:crimson_stems"));
        DECORATED_POT_SHERDS = MaterialTags.register("minecraft:decorated_pot_sherds", new LazilyInitializedMaterialTag("minecraft:decorated_pot_sherds"));
        DIAMOND_TIER = MaterialTags.register("minecraft:diamond_tier", new LazilyInitializedMaterialTag("minecraft:diamond_tier"));
        DIGGER = MaterialTags.register("minecraft:digger", new LazilyInitializedMaterialTag("minecraft:digger"));
        DOOR = MaterialTags.register("minecraft:door", new LazilyInitializedMaterialTag("minecraft:door"));
        GOLDEN_TIER = MaterialTags.register("minecraft:golden_tier", new LazilyInitializedMaterialTag("minecraft:golden_tier"));
        HANGING_ACTOR = MaterialTags.register("minecraft:hanging_actor", new LazilyInitializedMaterialTag("minecraft:hanging_actor"));
        HANGING_SIGN = MaterialTags.register("minecraft:hanging_sign", new LazilyInitializedMaterialTag("minecraft:hanging_sign"));
        HORSE_ARMOR = MaterialTags.register("minecraft:horse_armor", new LazilyInitializedMaterialTag("minecraft:horse_armor"));
        IRON_TIER = MaterialTags.register("minecraft:iron_tier", new LazilyInitializedMaterialTag("minecraft:iron_tier"));
        IS_ARMOR = MaterialTags.register("minecraft:is_armor", new LazilyInitializedMaterialTag("minecraft:is_armor"));
        IS_AXE = MaterialTags.register("minecraft:is_axe", new LazilyInitializedMaterialTag("minecraft:is_axe"));
        IS_COOKED = MaterialTags.register("minecraft:is_cooked", new LazilyInitializedMaterialTag("minecraft:is_cooked"));
        IS_FISH = MaterialTags.register("minecraft:is_fish", new LazilyInitializedMaterialTag("minecraft:is_fish"));
        IS_FOOD = MaterialTags.register("minecraft:is_food", new LazilyInitializedMaterialTag("minecraft:is_food"));
        IS_HOE = MaterialTags.register("minecraft:is_hoe", new LazilyInitializedMaterialTag("minecraft:is_hoe"));
        IS_MEAT = MaterialTags.register("minecraft:is_meat", new LazilyInitializedMaterialTag("minecraft:is_meat"));
        IS_MINECART = MaterialTags.register("minecraft:is_minecart", new LazilyInitializedMaterialTag("minecraft:is_minecart"));
        IS_PICKAXE = MaterialTags.register("minecraft:is_pickaxe", new LazilyInitializedMaterialTag("minecraft:is_pickaxe"));
        IS_SHOVEL = MaterialTags.register("minecraft:is_shovel", new LazilyInitializedMaterialTag("minecraft:is_shovel"));
        IS_SWORD = MaterialTags.register("minecraft:is_sword", new LazilyInitializedMaterialTag("minecraft:is_sword"));
        IS_TOOL = MaterialTags.register("minecraft:is_tool", new LazilyInitializedMaterialTag("minecraft:is_tool"));
        IS_TRIDENT = MaterialTags.register("minecraft:is_trident", new LazilyInitializedMaterialTag("minecraft:is_trident"));
        LEATHER_TIER = MaterialTags.register("minecraft:leather_tier", new LazilyInitializedMaterialTag("minecraft:leather_tier"));
        LECTERN_BOOKS = MaterialTags.register("minecraft:lectern_books", new LazilyInitializedMaterialTag("minecraft:lectern_books"));
        LOGS = MaterialTags.register("minecraft:logs", new LazilyInitializedMaterialTag("minecraft:logs"));
        LOGS_THAT_BURN = MaterialTags.register("minecraft:logs_that_burn", new LazilyInitializedMaterialTag("minecraft:logs_that_burn"));
        MANGROVE_LOGS = MaterialTags.register("minecraft:mangrove_logs", new LazilyInitializedMaterialTag("minecraft:mangrove_logs"));
        MUSIC_DISC = MaterialTags.register("minecraft:music_disc", new LazilyInitializedMaterialTag("minecraft:music_disc"));
        NETHERITE_TIER = MaterialTags.register("minecraft:netherite_tier", new LazilyInitializedMaterialTag("minecraft:netherite_tier"));
        PLANKS = MaterialTags.register("minecraft:planks", new LazilyInitializedMaterialTag("minecraft:planks"));
        SAND = MaterialTags.register("minecraft:sand", new LazilyInitializedMaterialTag("minecraft:sand"));
        SIGN = MaterialTags.register("minecraft:sign", new LazilyInitializedMaterialTag("minecraft:sign"));
        SOUL_FIRE_BASE_BLOCKS = MaterialTags.register("minecraft:soul_fire_base_blocks", new LazilyInitializedMaterialTag("minecraft:soul_fire_base_blocks"));
        SPAWN_EGG = MaterialTags.register("minecraft:spawn_egg", new LazilyInitializedMaterialTag("minecraft:spawn_egg"));
        STONE_BRICKS = MaterialTags.register("minecraft:stone_bricks", new LazilyInitializedMaterialTag("minecraft:stone_bricks"));
        STONE_CRAFTING_MATERIALS = MaterialTags.register("minecraft:stone_crafting_materials", new LazilyInitializedMaterialTag("minecraft:stone_crafting_materials"));
        STONE_TIER = MaterialTags.register("minecraft:stone_tier", new LazilyInitializedMaterialTag("minecraft:stone_tier"));
        STONE_TOOL_MATERIALS = MaterialTags.register("minecraft:stone_tool_materials", new LazilyInitializedMaterialTag("minecraft:stone_tool_materials"));
        TRANSFORM_MATERIALS = MaterialTags.register("minecraft:transform_materials", new LazilyInitializedMaterialTag("minecraft:transform_materials"));
        TRANSFORM_TEMPLATES = MaterialTags.register("minecraft:transform_templates", new LazilyInitializedMaterialTag("minecraft:transform_templates"));
        TRANSFORMABLE_ITEMS = MaterialTags.register("minecraft:transformable_items", new LazilyInitializedMaterialTag("minecraft:transformable_items"));
        TRIM_MATERIALS = MaterialTags.register("minecraft:trim_materials", new LazilyInitializedMaterialTag("minecraft:trim_materials"));
        TRIM_TEMPLATES = MaterialTags.register("minecraft:trim_templates", new LazilyInitializedMaterialTag("minecraft:trim_templates"));
        TRIMMABLE_ARMORS = MaterialTags.register("minecraft:trimmable_armors", new LazilyInitializedMaterialTag("minecraft:trimmable_armors"));
        VIBRATION_DAMPER = MaterialTags.register("minecraft:vibration_damper", new LazilyInitializedMaterialTag("minecraft:vibration_damper"));
        WARPED_STEMS = MaterialTags.register("minecraft:warped_stems", new LazilyInitializedMaterialTag("minecraft:warped_stems"));
        WOODEN_SLABS = MaterialTags.register("minecraft:wooden_slabs", new LazilyInitializedMaterialTag("minecraft:wooden_slabs"));
        WOODEN_TIER = MaterialTags.register("minecraft:wooden_tier", new LazilyInitializedMaterialTag("minecraft:wooden_tier"));
        WOOL = MaterialTags.register("minecraft:wool", new LazilyInitializedMaterialTag("minecraft:wool"));
    }
}

