/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.utils;

import cn.nukkit.Player;
import cn.nukkit.Server;
import cn.nukkit.nbt.NBTIO;
import cn.nukkit.nbt.tag.Tag;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.Map;
import java.util.SplittableRandom;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.GZIPInputStream;

public class Utils {
    public static final SplittableRandom random = new SplittableRandom();

    public static void writeFile(String fileName, String content) throws IOException {
        Utils.writeFile(fileName, (InputStream)new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8)));
    }

    public static void writeFile(String fileName, InputStream content) throws IOException {
        Utils.writeFile(new File(fileName), content);
    }

    public static void writeFile(File file, String content) throws IOException {
        Utils.writeFile(file, (InputStream)new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8)));
    }

    public static void writeFile(File file, InputStream content) throws IOException {
        if (content == null) {
            throw new IllegalArgumentException("content must not be null");
        }
        if (!file.exists()) {
            file.createNewFile();
        }
        try (FileOutputStream stream = new FileOutputStream(file);){
            int length;
            byte[] buffer = new byte[1024];
            while ((length = content.read(buffer)) != -1) {
                stream.write(buffer, 0, length);
            }
        }
        content.close();
    }

    public static String readFile(File file) throws IOException {
        if (!file.exists() || file.isDirectory()) {
            throw new FileNotFoundException();
        }
        return Utils.readFile(Files.newInputStream(file.toPath(), new OpenOption[0]));
    }

    public static String readFile(String filename) throws IOException {
        File file = new File(filename);
        if (!file.exists() || file.isDirectory()) {
            throw new FileNotFoundException();
        }
        return Utils.readFile(Files.newInputStream(file.toPath(), new OpenOption[0]));
    }

    public static String readFile(InputStream inputStream) throws IOException {
        return Utils.readFile(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
    }

    private static String readFile(Reader reader) throws IOException {
        try (BufferedReader br = new BufferedReader(reader);){
            StringBuilder stringBuilder = new StringBuilder();
            String temp = br.readLine();
            while (temp != null) {
                if (stringBuilder.length() != 0) {
                    stringBuilder.append('\n');
                }
                stringBuilder.append(temp);
                temp = br.readLine();
            }
            String string = stringBuilder.toString();
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File from, File to) throws IOException {
        if (!from.exists()) {
            throw new FileNotFoundException();
        }
        if (from.isDirectory() || to.isDirectory()) {
            throw new FileNotFoundException();
        }
        FileInputStream fi = null;
        AbstractInterruptibleChannel in = null;
        FileOutputStream fo = null;
        AbstractInterruptibleChannel out = null;
        try {
            if (!to.exists()) {
                to.createNewFile();
            }
            fi = new FileInputStream(from);
            in = fi.getChannel();
            fo = new FileOutputStream(to);
            out = fo.getChannel();
            ((FileChannel)in).transferTo(0L, ((FileChannel)in).size(), (WritableByteChannel)((Object)out));
        }
        finally {
            if (fi != null) {
                fi.close();
            }
            if (in != null) {
                in.close();
            }
            if (fo != null) {
                fo.close();
            }
            if (out != null) {
                out.close();
            }
        }
    }

    public static String getAllThreadDumps() {
        ThreadInfo[] threads = ManagementFactory.getThreadMXBean().dumpAllThreads(true, true);
        StringBuilder builder = new StringBuilder();
        for (ThreadInfo info : threads) {
            builder.append('\n').append(info);
        }
        return builder.toString();
    }

    public static String getExceptionMessage(Throwable e) {
        StringWriter stringWriter = new StringWriter();
        try (PrintWriter printWriter = new PrintWriter(stringWriter);){
            e.printStackTrace(printWriter);
            printWriter.flush();
        }
        return stringWriter.toString();
    }

    public static UUID dataToUUID(String ... params) {
        StringBuilder builder = new StringBuilder();
        for (String param : params) {
            builder.append(param);
        }
        return UUID.nameUUIDFromBytes(builder.toString().getBytes(StandardCharsets.UTF_8));
    }

    public static UUID dataToUUID(byte[] ... params) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        for (byte[] param : params) {
            try {
                stream.write(param);
            }
            catch (IOException e) {
                break;
            }
        }
        return UUID.nameUUIDFromBytes(stream.toByteArray());
    }

    public static String rtrim(String s2, char character) {
        int i;
        for (i = s2.length() - 1; i >= 0 && s2.charAt(i) == character; --i) {
        }
        return s2.substring(0, i + 1);
    }

    public static boolean isByteArrayEmpty(byte[] array) {
        for (byte b : array) {
            if (b == 0) continue;
            return false;
        }
        return true;
    }

    public static long toRGB(byte r, byte g2, byte b, byte a) {
        long result = r & 0xFF;
        result |= (long)((g2 & 0xFF) << 8);
        result |= (long)((b & 0xFF) << 16);
        return (result |= (long)((a & 0xFF) << 24)) & 0xFFFFFFFFL;
    }

    public static long toABGR(int argb) {
        long result = (long)argb & 0xFF00FF00L;
        result |= (long)(argb << 16) & 0xFF0000L;
        return (result |= (long)(argb >>> 16) & 0xFFL) & 0xFFFFFFFFL;
    }

    public static Object[][] splitArray(Object[] arrayToSplit, int chunkSize) {
        if (chunkSize <= 0) {
            return null;
        }
        int rest = arrayToSplit.length % chunkSize;
        int chunks = arrayToSplit.length / chunkSize + (rest > 0 ? 1 : 0);
        Object[][] arrays = new Object[chunks][];
        for (int i = 0; i < (rest > 0 ? chunks - 1 : chunks); ++i) {
            arrays[i] = Arrays.copyOfRange(arrayToSplit, i * chunkSize, i * chunkSize + chunkSize);
        }
        if (rest > 0) {
            arrays[chunks - 1] = Arrays.copyOfRange(arrayToSplit, (chunks - 1) * chunkSize, (chunks - 1) * chunkSize + rest);
        }
        return arrays;
    }

    public static <T> void reverseArray(T[] data) {
        Utils.reverseArray(data, false);
    }

    public static <T> T[] reverseArray(T[] array, boolean copy) {
        T[] data = array;
        if (copy) {
            data = Arrays.copyOf(array, array.length);
        }
        int left = 0;
        for (int right = data.length - 1; left < right; ++left, --right) {
            T temp = data[left];
            data[left] = data[right];
            data[right] = temp;
        }
        return data;
    }

    public static <T> T[][] clone2dArray(T[][] array) {
        Object[][] newArray = (Object[][])Arrays.copyOf(array, array.length);
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = Arrays.copyOf(array[i], array[i].length);
        }
        return newArray;
    }

    public static <T, U, V> Map<U, V> getOrCreate(Map<T, Map<U, V>> map, T key) {
        ConcurrentHashMap toPut;
        ConcurrentHashMap existing = map.get(key);
        if (existing == null && (existing = (ConcurrentHashMap)map.putIfAbsent(key, toPut = new ConcurrentHashMap())) == null) {
            existing = toPut;
        }
        return existing;
    }

    public static <T, U, V extends U> U getOrCreate(Map<T, U> map, Class<V> clazz, T key) {
        U existing = map.get(key);
        if (existing != null) {
            return existing;
        }
        try {
            V toPut = clazz.newInstance();
            existing = map.putIfAbsent(key, toPut);
            if (existing == null) {
                return (U)toPut;
            }
            return existing;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    public static int toInt(Object number) {
        if (number instanceof Integer) {
            return (Integer)number;
        }
        return (int)Math.round((Double)number);
    }

    public static byte[] parseHexBinary(String s2) {
        int len = s2.length();
        if (len % 2 != 0) {
            throw new IllegalArgumentException("hexBinary needs to be even-length: " + s2);
        }
        byte[] out = new byte[len >> 1];
        for (int i = 0; i < len; i += 2) {
            int h2 = Utils.hexToBin(s2.charAt(i));
            int l = Utils.hexToBin(s2.charAt(i + 1));
            if (h2 == -1 || l == -1) {
                throw new IllegalArgumentException("contains illegal character for hexBinary: " + s2);
            }
            out[i >> 1] = (byte)((h2 << 4) + l);
        }
        return out;
    }

    private static int hexToBin(char ch) {
        if ('0' <= ch && ch <= '9') {
            return ch - 48;
        }
        if ('A' <= ch && ch <= 'F') {
            return ch - 65 + 10;
        }
        if ('a' <= ch && ch <= 'f') {
            return ch - 97 + 10;
        }
        return -1;
    }

    public static int rand(int min2, int max) {
        if (min2 == max) {
            return max;
        }
        return random.nextInt(max + 1 - min2) + min2;
    }

    public static double rand(double min2, double max) {
        if (min2 == max) {
            return max;
        }
        return min2 + random.nextDouble() * (max - min2);
    }

    public static boolean rand() {
        return random.nextBoolean();
    }

    public static String getOS(Player player) {
        switch (player.getLoginChainData().getDeviceOS()) {
            case 1: {
                return "Android";
            }
            case 2: {
                return "iOS";
            }
            case 3: {
                return "macOS";
            }
            case 4: {
                return "Fire OS";
            }
            case 5: {
                return "Gear VR";
            }
            case 6: {
                return "HoloLens";
            }
            case 7: {
                return "Windows 10";
            }
            case 8: {
                return "Windows";
            }
            case 9: {
                return "Dedicated";
            }
            case 10: {
                return "tvOS";
            }
            case 11: {
                return "PlayStation";
            }
            case 12: {
                return "Switch";
            }
            case 13: {
                return "Xbox";
            }
            case 14: {
                return "Windows Phone";
            }
            case 15: {
                return "Linux";
            }
        }
        return "Unknown";
    }

    public static JsonElement loadJsonResource(String file) {
        try {
            InputStream stream = Server.class.getClassLoader().getResourceAsStream(file);
            if (stream == null) {
                throw new AssertionError((Object)("Unable to load " + file));
            }
            JsonElement element = JsonParser.parseReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
            stream.close();
            return element;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to load " + file, e);
        }
    }

    public static Tag loadTagResource(String file) {
        try {
            InputStream stream = Server.class.getClassLoader().getResourceAsStream(file);
            if (stream == null) {
                throw new AssertionError((Object)("Unable to load " + file));
            }
            Tag tag = NBTIO.readTag(new BufferedInputStream(new GZIPInputStream(stream)), ByteOrder.BIG_ENDIAN, false);
            stream.close();
            return tag;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to load " + file, e);
        }
    }
}

