/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public enum TextFormat {
    BLACK('0'),
    DARK_BLUE('1'),
    DARK_GREEN('2'),
    DARK_AQUA('3'),
    DARK_RED('4'),
    DARK_PURPLE('5'),
    GOLD('6'),
    GRAY('7'),
    DARK_GRAY('8'),
    BLUE('9'),
    GREEN('a'),
    AQUA('b'),
    RED('c'),
    LIGHT_PURPLE('d'),
    YELLOW('e'),
    WHITE('f'),
    MINECOIN_GOLD('g'),
    OBFUSCATED('k', true),
    BOLD('l', true),
    STRIKETHROUGH('m', true),
    UNDERLINE('n', true),
    ITALIC('o', true),
    RESET('r'),
    MATERIAL_QUARTZ('h'),
    MATERIAL_IRON('i'),
    MATERIAL_NETHERITE('j'),
    MATERIAL_REDSTONE('m'),
    MATERIAL_COPPER('n'),
    MATERIAL_GOLD('p'),
    MATERIAL_EMERALD('q'),
    MATERIAL_DIAMOND('s'),
    MATERIAL_LAPIS('t'),
    MATERIAL_AMETHYST('u');

    public static final char ESCAPE = '\u00a7';
    private static final Pattern CLEAN_PATTERN;
    private static final Map<Character, TextFormat> BY_CHAR;
    private final char code;
    private final boolean isFormat;
    private final String toString;

    private TextFormat(char code) {
        this(code, false);
    }

    private TextFormat(char code, boolean isFormat) {
        this.code = code;
        this.isFormat = isFormat;
        this.toString = new String(new char[]{'\u00a7', code});
    }

    public static TextFormat getByChar(char code) {
        return BY_CHAR.get(Character.valueOf(code));
    }

    public static TextFormat getByChar(String code) {
        if (code == null || code.length() <= 1) {
            return null;
        }
        return BY_CHAR.get(Character.valueOf(code.charAt(0)));
    }

    public static String clean(String input) {
        return TextFormat.clean(input, false);
    }

    public static String clean(String input, boolean recursive) {
        if (input == null) {
            return null;
        }
        String result = CLEAN_PATTERN.matcher(input).replaceAll("");
        if (recursive && CLEAN_PATTERN.matcher(result).find()) {
            return TextFormat.clean(result, true);
        }
        return result;
    }

    public static String colorize(char altFormatChar, String textToTranslate) {
        char[] b = textToTranslate.toCharArray();
        for (int i = 0; i < b.length - 1; ++i) {
            int x = i + 1;
            if (b[i] != altFormatChar || "0123456789AaBbCcDdEeFfGgHhIiJjKkLlMmNnOoPpQqRrSsTtUu".indexOf(b[x]) <= -1) continue;
            b[i] = 167;
            b[x] = Character.toLowerCase(b[x]);
        }
        return new String(b);
    }

    public static String colorize(String textToTranslate) {
        return TextFormat.colorize('&', textToTranslate);
    }

    public static String getLastColors(String input) {
        StringBuilder result = new StringBuilder();
        int length = input.length();
        for (int index = length - 1; index > -1; --index) {
            TextFormat color;
            if (input.charAt(index) != '\u00a7' || index >= length - 1 || (color = TextFormat.getByChar(input.charAt(index + 1))) == null) continue;
            result.insert(0, color.toString());
            if (color.isColor() || color.equals((Object)RESET)) break;
        }
        return result.toString();
    }

    public char getChar() {
        return this.code;
    }

    public String toString() {
        return this.toString;
    }

    public boolean isFormat() {
        return this.isFormat;
    }

    public boolean isColor() {
        return !this.isFormat && this != RESET;
    }

    static {
        CLEAN_PATTERN = Pattern.compile("(?i)\u00a7[0-9A-U]");
        BY_CHAR = new HashMap<Character, TextFormat>();
        for (TextFormat color : TextFormat.values()) {
            BY_CHAR.put(Character.valueOf(color.code), color);
        }
    }
}

