/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.utils;

import cn.nukkit.Server;
import cn.nukkit.plugin.Plugin;
import cn.nukkit.utils.Config;
import cn.nukkit.utils.ConfigSection;
import java.io.File;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;

public abstract class SimpleConfig {
    private final File configFile;

    public SimpleConfig(Plugin plugin) {
        this(plugin, "config.yml");
    }

    public SimpleConfig(Plugin plugin, String fileName) {
        this(new File(plugin.getDataFolder() + File.separator + fileName));
    }

    public SimpleConfig(File file) {
        this.configFile = file;
        this.configFile.getParentFile().mkdirs();
    }

    public boolean save() {
        return this.save(false);
    }

    public boolean save(boolean async) {
        if (this.configFile.exists()) {
            try {
                this.configFile.createNewFile();
            }
            catch (Exception e) {
                return false;
            }
        }
        Config cfg = new Config(this.configFile, 2);
        for (Field field : this.getClass().getDeclaredFields()) {
            if (SimpleConfig.skipSave(field)) continue;
            String path = SimpleConfig.getPath(field);
            try {
                if (path == null) continue;
                cfg.set(path, field.get(this));
            }
            catch (Exception e) {
                return false;
            }
        }
        cfg.save(async);
        return true;
    }

    public boolean load() {
        if (!this.configFile.exists()) {
            return false;
        }
        Config cfg = new Config(this.configFile, 2);
        for (Field field : this.getClass().getDeclaredFields()) {
            String path;
            if (field.getName().equals("configFile") || this.skipLoad(field) || (path = SimpleConfig.getPath(field)) == null || path.isEmpty()) continue;
            field.setAccessible(true);
            try {
                if (field.getType() == Integer.TYPE || field.getType() == Integer.class) {
                    field.set(this, cfg.getInt(path, field.getInt(this)));
                    continue;
                }
                if (field.getType() == Boolean.TYPE || field.getType() == Boolean.class) {
                    field.set(this, cfg.getBoolean(path, field.getBoolean(this)));
                    continue;
                }
                if (field.getType() == Long.TYPE || field.getType() == Long.class) {
                    field.set(this, cfg.getLong(path, field.getLong(this)));
                    continue;
                }
                if (field.getType() == Double.TYPE || field.getType() == Double.class) {
                    field.set(this, cfg.getDouble(path, field.getDouble(this)));
                    continue;
                }
                if (field.getType() == String.class) {
                    field.set(this, cfg.getString(path, (String)field.get(this)));
                    continue;
                }
                if (field.getType() == ConfigSection.class) {
                    field.set(this, cfg.getSection(path));
                    continue;
                }
                if (field.getType() == List.class) {
                    Type genericFieldType = field.getGenericType();
                    if (genericFieldType instanceof ParameterizedType) {
                        ParameterizedType aType = (ParameterizedType)genericFieldType;
                        Class fieldArgClass = (Class)aType.getActualTypeArguments()[0];
                        if (fieldArgClass == Integer.class) {
                            field.set(this, cfg.getIntegerList(path));
                            continue;
                        }
                        if (fieldArgClass == Boolean.class) {
                            field.set(this, cfg.getBooleanList(path));
                            continue;
                        }
                        if (fieldArgClass == Double.class) {
                            field.set(this, cfg.getDoubleList(path));
                            continue;
                        }
                        if (fieldArgClass == Character.class) {
                            field.set(this, cfg.getCharacterList(path));
                            continue;
                        }
                        if (fieldArgClass == Byte.class) {
                            field.set(this, cfg.getByteList(path));
                            continue;
                        }
                        if (fieldArgClass == Float.class) {
                            field.set(this, cfg.getFloatList(path));
                            continue;
                        }
                        if (fieldArgClass == Short.class) {
                            field.set(this, cfg.getFloatList(path));
                            continue;
                        }
                        if (fieldArgClass != String.class) continue;
                        field.set(this, cfg.getStringList(path));
                        continue;
                    }
                    field.set(this, cfg.getList(path));
                    continue;
                }
                throw new IllegalStateException("SimpleConfig did not supports class: " + field.getType().getName() + " for config field " + this.configFile.getName());
            }
            catch (Exception e) {
                Server.getInstance().getLogger().logException(e);
                return false;
            }
        }
        return true;
    }

    private static String getPath(Field field) {
        String path = null;
        if (field.isAnnotationPresent(Path.class)) {
            Path pathDefine = field.getAnnotation(Path.class);
            path = pathDefine.value();
        }
        if (path == null || path.isEmpty()) {
            path = field.getName().replace("_", ".");
        }
        if (Modifier.isFinal(field.getModifiers())) {
            return null;
        }
        if (Modifier.isPrivate(field.getModifiers())) {
            field.setAccessible(true);
        }
        return path;
    }

    private static boolean skipSave(Field field) {
        if (!field.isAnnotationPresent(Skip.class)) {
            return false;
        }
        return field.getAnnotation(Skip.class).skipSave();
    }

    private boolean skipLoad(Field field) {
        if (!field.isAnnotationPresent(Skip.class)) {
            return false;
        }
        return field.getAnnotation(Skip.class).skipLoad();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Skip {
        public boolean skipSave() default true;

        public boolean skipLoad() default true;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Path {
        public String value() default "";
    }
}

