/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.utils;

import cn.nukkit.utils.MainLogger;
import java.util.function.BiConsumer;
import org.apache.logging.log4j.util.TriConsumer;

public enum LogLevel implements Comparable<LogLevel>
{
    NONE((logger, message) -> {}, (mainLogger, s2, throwable) -> {}),
    EMERGENCY(MainLogger::emergency, MainLogger::emergency),
    ALERT(MainLogger::alert, MainLogger::alert),
    CRITICAL(MainLogger::critical, MainLogger::critical),
    ERROR(MainLogger::error, MainLogger::error),
    WARNING(MainLogger::warning, MainLogger::warning),
    NOTICE(MainLogger::notice, MainLogger::notice),
    INFO(MainLogger::info, MainLogger::info),
    DEBUG(MainLogger::debug, MainLogger::debug);

    @Deprecated
    public static final LogLevel DEFAULT_LEVEL;
    private final BiConsumer<MainLogger, String> logTo;
    private final TriConsumer<MainLogger, String, Throwable> logThrowableTo;

    private LogLevel(BiConsumer<MainLogger, String> logTo, TriConsumer<MainLogger, String, Throwable> logThrowableTo) {
        this.logTo = logTo;
        this.logThrowableTo = logThrowableTo;
    }

    public void log(MainLogger logger, String message) {
        this.logTo.accept(logger, message);
    }

    public void log(MainLogger logger, String message, Throwable throwable) {
        this.logThrowableTo.accept(logger, message, throwable);
    }

    public int getLevel() {
        return this.ordinal();
    }

    static {
        DEFAULT_LEVEL = INFO;
    }
}

