/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.utils;

import cn.nukkit.utils.BlockColor;

public enum DyeColor {
    BLACK(0, 15, "Black", "Ink Sac", BlockColor.BLACK_BLOCK_COLOR, new BlockColor(0, 0, 0)),
    RED(1, 14, "Red", BlockColor.RED_BLOCK_COLOR, new BlockColor(176, 46, 38)),
    GREEN(2, 13, "Green", BlockColor.GREEN_BLOCK_COLOR, new BlockColor(94, 124, 22)),
    BROWN(3, 12, "Brown", "Cocoa Beans", BlockColor.BROWN_BLOCK_COLOR, new BlockColor(131, 84, 50)),
    BLUE(4, 11, "Blue", "Lapis Lazuli", BlockColor.BLUE_BLOCK_COLOR, new BlockColor(60, 68, 170)),
    PURPLE(5, 10, "Purple", BlockColor.PURPLE_BLOCK_COLOR, new BlockColor(137, 50, 184)),
    CYAN(6, 9, "Cyan", BlockColor.CYAN_BLOCK_COLOR, new BlockColor(22, 156, 156)),
    LIGHT_GRAY(7, 8, "Light Gray", BlockColor.LIGHT_GRAY_BLOCK_COLOR, new BlockColor(157, 157, 151)),
    GRAY(8, 7, "Gray", BlockColor.GRAY_BLOCK_COLOR, new BlockColor(71, 79, 82)),
    PINK(9, 6, "Pink", BlockColor.PINK_BLOCK_COLOR, new BlockColor(243, 139, 170)),
    LIME(10, 5, "Lime", BlockColor.LIME_BLOCK_COLOR, new BlockColor(128, 199, 31)),
    YELLOW(11, 4, "Yellow", BlockColor.YELLOW_BLOCK_COLOR, new BlockColor(254, 216, 61)),
    LIGHT_BLUE(12, 3, "Light Blue", BlockColor.LIGHT_BLUE_BLOCK_COLOR, new BlockColor(58, 179, 218)),
    MAGENTA(13, 2, "Magenta", BlockColor.MAGENTA_BLOCK_COLOR, new BlockColor(199, 78, 189)),
    ORANGE(14, 1, "Orange", BlockColor.ORANGE_BLOCK_COLOR, new BlockColor(249, 128, 29)),
    WHITE(15, 0, "White", "Bone Meal", BlockColor.WHITE_BLOCK_COLOR, new BlockColor(240, 240, 240));

    private final int dyeColorMeta;
    private final int woolColorMeta;
    private final String colorName;
    private final String dyeName;
    private final BlockColor blockColor;
    private final BlockColor signColor;
    private static final DyeColor[] BY_WOOL_DATA;
    private static final DyeColor[] BY_DYE_DATA;

    private DyeColor(int dyeColorMeta, int woolColorMeta, String colorName, BlockColor blockColor, BlockColor signColor) {
        this(dyeColorMeta, woolColorMeta, colorName, colorName + " Dye", blockColor, signColor);
    }

    private DyeColor(int dyeColorMeta, int woolColorMeta, String colorName, String dyeName, BlockColor blockColor, BlockColor signColor) {
        this.dyeColorMeta = dyeColorMeta;
        this.woolColorMeta = woolColorMeta;
        this.colorName = colorName;
        this.blockColor = blockColor;
        this.signColor = signColor;
        this.dyeName = dyeName;
    }

    public BlockColor getColor() {
        return this.blockColor;
    }

    public BlockColor getSignColor() {
        return this.signColor;
    }

    public int getDyeData() {
        return this.dyeColorMeta;
    }

    public int getWoolData() {
        return this.woolColorMeta;
    }

    public String getName() {
        return this.colorName;
    }

    public String getDyeName() {
        return this.dyeName;
    }

    public static DyeColor getByDyeData(int dyeColorMeta) {
        return BY_DYE_DATA[dyeColorMeta & 0xF];
    }

    public static DyeColor getByWoolData(int woolColorMeta) {
        return BY_WOOL_DATA[woolColorMeta & 0xF];
    }

    static {
        BY_DYE_DATA = DyeColor.values();
        BY_WOOL_DATA = DyeColor.values();
        DyeColor[] dyeColorArray = DyeColor.values();
        int n = dyeColorArray.length;
        for (int i = 0; i < n; ++i) {
            DyeColor color;
            DyeColor.BY_WOOL_DATA[color.woolColorMeta & 0xF] = color = dyeColorArray[i];
            DyeColor.BY_DYE_DATA[color.dyeColorMeta & 0xF] = color;
        }
    }
}

