/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.utils;

import cn.nukkit.Server;
import cn.nukkit.utils.PlayerDataSerializer;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Optional;
import java.util.UUID;

public class DefaultPlayerDataSerializer
implements PlayerDataSerializer {
    private final String dataPath;

    public DefaultPlayerDataSerializer(Server server) {
        this(server.getDataPath());
    }

    public DefaultPlayerDataSerializer(String dataPath) {
        this.dataPath = dataPath;
    }

    @Override
    public Optional<InputStream> read(String name, UUID uuid) throws IOException {
        File file = new File(this.dataPath + "players/" + name + ".dat");
        if (!file.exists()) {
            return Optional.empty();
        }
        return Optional.of(Files.newInputStream(file.toPath(), new OpenOption[0]));
    }

    @Override
    public OutputStream write(String name, UUID uuid) throws IOException {
        Preconditions.checkNotNull(name, "name");
        File file = new File(this.dataPath + "players/" + name + ".dat");
        return Files.newOutputStream(file.toPath(), new OpenOption[0]);
    }
}

