/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.utils;

import cn.nukkit.network.encryption.EncryptionUtils;
import cn.nukkit.network.protocol.LoginPacket;
import cn.nukkit.utils.BinaryStream;
import cn.nukkit.utils.LoginChainData;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import com.nimbusds.jose.JWSObject;
import com.nimbusds.jose.crypto.ECDSAVerifier;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.ECPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

public final class ClientChainData
implements LoginChainData {
    private static final Gson GSON = new Gson();
    private boolean xboxAuthed;
    public static final int UI_PROFILE_CLASSIC = 0;
    public static final int UI_PROFILE_POCKET = 1;
    private String username;
    private UUID clientUUID;
    private String xuid;
    private String identityPublicKey;
    private long clientId;
    private String serverAddress;
    private String deviceModel;
    private int deviceOS;
    private String deviceId;
    private String gameVersion;
    private int guiScale;
    private String languageCode;
    private int currentInputMode;
    private int defaultInputMode;
    private int UIProfile;
    private String capeData;
    private String titleId;
    private JsonObject rawData;
    private final BinaryStream bs = new BinaryStream();

    public static ClientChainData of(byte[] buffer) {
        return new ClientChainData(buffer);
    }

    public static ClientChainData read(LoginPacket pk) {
        return ClientChainData.of(pk.getBuffer());
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public UUID getClientUUID() {
        return this.clientUUID;
    }

    @Override
    public String getIdentityPublicKey() {
        return this.identityPublicKey;
    }

    @Override
    public long getClientId() {
        return this.clientId;
    }

    @Override
    public String getServerAddress() {
        return this.serverAddress;
    }

    @Override
    public String getDeviceModel() {
        return this.deviceModel;
    }

    @Override
    public int getDeviceOS() {
        return this.deviceOS;
    }

    @Override
    public String getDeviceId() {
        return this.deviceId;
    }

    @Override
    public String getGameVersion() {
        return this.gameVersion;
    }

    @Override
    public int getGuiScale() {
        return this.guiScale;
    }

    @Override
    public String getLanguageCode() {
        return this.languageCode;
    }

    @Override
    public String getXUID() {
        return this.xuid;
    }

    @Override
    public int getCurrentInputMode() {
        return this.currentInputMode;
    }

    @Override
    public int getDefaultInputMode() {
        return this.defaultInputMode;
    }

    @Override
    public String getCapeData() {
        return this.capeData;
    }

    @Override
    public int getUIProfile() {
        return this.UIProfile;
    }

    @Override
    public String getTitleId() {
        return this.titleId;
    }

    @Override
    public JsonObject getRawData() {
        return this.rawData;
    }

    public boolean equals(Object obj) {
        return obj instanceof ClientChainData && Objects.equals(this.bs, ((ClientChainData)obj).bs);
    }

    public int hashCode() {
        return this.bs.hashCode();
    }

    private static ECPublicKey generateKey(String base64) throws NoSuchAlgorithmException, InvalidKeySpecException {
        return (ECPublicKey)KeyFactory.getInstance("EC").generatePublic(new X509EncodedKeySpec(Base64.getDecoder().decode(base64)));
    }

    private ClientChainData(byte[] buffer) {
        this.bs.setBuffer(buffer, 0);
        this.decodeChainData();
        this.decodeSkinData();
    }

    @Override
    public boolean isXboxAuthed() {
        return this.xboxAuthed;
    }

    private void decodeSkinData() {
        int size = this.bs.getLInt();
        if (size > 0x3200000) {
            throw new TooBigSkinException("The skin data is too big: " + size);
        }
        JsonObject skinToken = ClientChainData.decodeToken(new String(this.bs.get(size), StandardCharsets.UTF_8));
        if (skinToken == null) {
            throw new RuntimeException("Invalid null skin token");
        }
        if (skinToken.has("ClientRandomId")) {
            this.clientId = skinToken.get("ClientRandomId").getAsLong();
        }
        if (skinToken.has("ServerAddress")) {
            this.serverAddress = skinToken.get("ServerAddress").getAsString();
        }
        if (skinToken.has("DeviceModel")) {
            this.deviceModel = skinToken.get("DeviceModel").getAsString();
        }
        if (skinToken.has("DeviceOS")) {
            this.deviceOS = skinToken.get("DeviceOS").getAsInt();
        }
        if (skinToken.has("DeviceId")) {
            this.deviceId = skinToken.get("DeviceId").getAsString();
        }
        if (skinToken.has("GameVersion")) {
            this.gameVersion = skinToken.get("GameVersion").getAsString();
        }
        if (skinToken.has("GuiScale")) {
            this.guiScale = skinToken.get("GuiScale").getAsInt();
        }
        if (skinToken.has("LanguageCode")) {
            this.languageCode = skinToken.get("LanguageCode").getAsString();
        }
        if (skinToken.has("CurrentInputMode")) {
            this.currentInputMode = skinToken.get("CurrentInputMode").getAsInt();
        }
        if (skinToken.has("DefaultInputMode")) {
            this.defaultInputMode = skinToken.get("DefaultInputMode").getAsInt();
        }
        if (skinToken.has("UIProfile")) {
            this.UIProfile = skinToken.get("UIProfile").getAsInt();
        }
        if (skinToken.has("CapeData")) {
            this.capeData = skinToken.get("CapeData").getAsString();
        }
        this.rawData = skinToken;
    }

    public static JsonObject decodeToken(String token) {
        String[] base = token.split("\\.", 100);
        if (base.length < 2) {
            return null;
        }
        return GSON.fromJson(new String(Base64.getDecoder().decode(base[1]), StandardCharsets.UTF_8), JsonObject.class);
    }

    private void decodeChainData() {
        int size = this.bs.getLInt();
        if (size > 0x300000) {
            throw new IllegalArgumentException("The chain data is too big: " + size);
        }
        Map map = (Map)GSON.fromJson(new String(this.bs.get(size), StandardCharsets.UTF_8), new MapTypeToken().getType());
        if (map.isEmpty() || !map.containsKey("chain") || ((List)map.get("chain")).isEmpty()) {
            return;
        }
        List chains = (List)map.get("chain");
        try {
            this.xboxAuthed = ClientChainData.verifyChain(chains);
        }
        catch (Exception e) {
            this.xboxAuthed = false;
        }
        for (String c : chains) {
            JsonObject chainMap = ClientChainData.decodeToken(c);
            if (chainMap == null) continue;
            if (chainMap.has("extraData")) {
                JsonObject extra = chainMap.get("extraData").getAsJsonObject();
                if (extra.has("displayName")) {
                    this.username = extra.get("displayName").getAsString();
                }
                if (extra.has("identity")) {
                    this.clientUUID = UUID.fromString(extra.get("identity").getAsString());
                }
                if (extra.has("XUID")) {
                    this.xuid = extra.get("XUID").getAsString();
                }
                if (extra.has("titleId")) {
                    this.titleId = extra.get("titleId").getAsString();
                }
            }
            if (!chainMap.has("identityPublicKey")) continue;
            this.identityPublicKey = chainMap.get("identityPublicKey").getAsString();
        }
        if (!this.xboxAuthed) {
            this.xuid = null;
        }
    }

    private static boolean verifyChain(List<String> chains) throws Exception {
        ECPublicKey lastKey = null;
        boolean mojangKeyVerified = false;
        Iterator<String> iterator = chains.iterator();
        while (iterator.hasNext()) {
            Object base64key;
            JWSObject jws = JWSObject.parse(iterator.next());
            URI x5u = jws.getHeader().getX509CertURL();
            if (x5u == null) {
                return false;
            }
            ECPublicKey expectedKey = ClientChainData.generateKey(x5u.toString());
            if (lastKey == null) {
                lastKey = expectedKey;
            } else if (!lastKey.equals(expectedKey)) {
                return false;
            }
            if (!jws.verify(new ECDSAVerifier(lastKey))) {
                return false;
            }
            if (mojangKeyVerified) {
                return !iterator.hasNext();
            }
            if (lastKey.equals(EncryptionUtils.getMojangPublicKey())) {
                mojangKeyVerified = true;
            }
            if (!((base64key = jws.getPayload().toJSONObject().get("identityPublicKey")) instanceof String)) {
                throw new RuntimeException("No key found");
            }
            lastKey = ClientChainData.generateKey((String)base64key);
        }
        return mojangKeyVerified;
    }

    public static class TooBigSkinException
    extends RuntimeException {
        public TooBigSkinException(String s2) {
            super(s2);
        }
    }

    private static class MapTypeToken
    extends TypeToken<Map<String, List<String>>> {
        private MapTypeToken() {
        }
    }
}

