/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.utils;

import cn.nukkit.block.Block;
import cn.nukkit.entity.Attribute;
import cn.nukkit.entity.data.Skin;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.item.ItemDurable;
import cn.nukkit.item.RuntimeItemMapping;
import cn.nukkit.item.RuntimeItems;
import cn.nukkit.level.GameRule;
import cn.nukkit.level.GameRules;
import cn.nukkit.level.GlobalBlockPalette;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.BlockVector3;
import cn.nukkit.math.Vector2f;
import cn.nukkit.math.Vector3f;
import cn.nukkit.nbt.NBTIO;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.ListTag;
import cn.nukkit.nbt.tag.StringTag;
import cn.nukkit.nbt.tag.Tag;
import cn.nukkit.network.LittleEndianByteBufInputStream;
import cn.nukkit.network.LittleEndianByteBufOutputStream;
import cn.nukkit.network.protocol.types.EntityLink;
import cn.nukkit.network.protocol.types.ExperimentData;
import cn.nukkit.utils.Binary;
import cn.nukkit.utils.PersonaPiece;
import cn.nukkit.utils.PersonaPieceTint;
import cn.nukkit.utils.SerializedImage;
import cn.nukkit.utils.SkinAnimation;
import cn.nukkit.utils.VarInt;
import com.google.common.collect.ImmutableList;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.Array;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.cloudburstmc.nbt.NBTOutputStream;
import org.cloudburstmc.nbt.NbtUtils;

public class BinaryStream {
    public int offset;
    private byte[] buffer;
    protected int count;
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;

    public BinaryStream() {
        this.buffer = new byte[32];
        this.offset = 0;
        this.count = 0;
    }

    public BinaryStream(byte[] buffer) {
        this(buffer, 0);
    }

    public BinaryStream(byte[] buffer, int offset) {
        this.buffer = buffer;
        this.offset = offset;
        this.count = buffer.length;
    }

    public BinaryStream reset() {
        this.offset = 0;
        this.count = 0;
        return this;
    }

    public void setBuffer(byte[] buffer) {
        this.buffer = buffer;
        this.count = buffer == null ? -1 : buffer.length;
    }

    public void setBuffer(byte[] buffer, int offset) {
        this.setBuffer(buffer);
        this.setOffset(offset);
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public byte[] getBuffer() {
        return Arrays.copyOf(this.buffer, this.count);
    }

    public byte[] getRawBuffer() {
        return this.buffer;
    }

    public int getCount() {
        return this.count;
    }

    public byte[] get() {
        return this.get(this.count - this.offset);
    }

    public byte[] get(int len) {
        if (len < 0) {
            this.offset = this.count - 1;
            return new byte[0];
        }
        len = Math.min(len, this.count - this.offset);
        this.offset += len;
        return Arrays.copyOfRange(this.buffer, this.offset - len, this.offset);
    }

    public void put(byte[] bytes) {
        this.ensureCapacity(this.count + bytes.length);
        System.arraycopy(bytes, 0, this.buffer, this.count, bytes.length);
        this.count += bytes.length;
    }

    public long getLong() {
        return Binary.readLong(this.get(8));
    }

    public void putLong(long l) {
        this.put(Binary.writeLong(l));
    }

    public int getInt() {
        return Binary.readInt(this.get(4));
    }

    public void putInt(int i) {
        this.put(Binary.writeInt(i));
    }

    public long getLLong() {
        return Binary.readLLong(this.get(8));
    }

    public void putLLong(long l) {
        this.put(Binary.writeLLong(l));
    }

    public int getLInt() {
        return Binary.readLInt(this.get(4));
    }

    public void putLInt(int i) {
        this.put(Binary.writeLInt(i));
    }

    public int getShort() {
        return Binary.readShort(this.get(2));
    }

    public void putShort(int s2) {
        this.put(Binary.writeShort(s2));
    }

    public int getLShort() {
        return Binary.readLShort(this.get(2));
    }

    public void putLShort(int s2) {
        this.put(Binary.writeLShort(s2));
    }

    public float getFloat() {
        return this.getFloat(-1);
    }

    public float getFloat(int accuracy) {
        return Binary.readFloat(this.get(4), accuracy);
    }

    public void putFloat(float v) {
        this.put(Binary.writeFloat(v));
    }

    public float getLFloat() {
        return this.getLFloat(-1);
    }

    public float getLFloat(int accuracy) {
        return Binary.readLFloat(this.get(4), accuracy);
    }

    public void putLFloat(float v) {
        this.put(Binary.writeLFloat(v));
    }

    public int getTriad() {
        return Binary.readTriad(this.get(3));
    }

    public void putTriad(int triad) {
        this.put(Binary.writeTriad(triad));
    }

    public int getLTriad() {
        return Binary.readLTriad(this.get(3));
    }

    public void putLTriad(int triad) {
        this.put(Binary.writeLTriad(triad));
    }

    public boolean getBoolean() {
        return this.getByte() == 1;
    }

    public void putBoolean(boolean bool) {
        this.putByte((byte)(bool ? 1 : 0));
    }

    public int getByte() {
        return this.buffer[this.offset++] & 0xFF;
    }

    public void putByte(byte b) {
        this.put(new byte[]{b});
    }

    public Attribute[] getAttributeList() throws Exception {
        ArrayList<Attribute> list = new ArrayList<Attribute>();
        long count = this.getUnsignedVarInt();
        int i = 0;
        while ((long)i < count) {
            String name = this.getString();
            Attribute attr = Attribute.getAttributeByName(name);
            if (attr == null) {
                throw new Exception("Unknown attribute type \"" + name + '\"');
            }
            attr.setMinValue(this.getLFloat());
            attr.setValue(this.getLFloat());
            attr.setMaxValue(this.getLFloat());
            list.add(attr);
            ++i;
        }
        return list.toArray(new Attribute[0]);
    }

    public void putAttributeList(Attribute[] attributes) {
        this.putUnsignedVarInt(attributes.length);
        for (Attribute attribute : attributes) {
            this.putString(attribute.getName());
            this.putLFloat(attribute.getMinValue());
            this.putLFloat(attribute.getValue());
            this.putLFloat(attribute.getMaxValue());
        }
    }

    public void putUUID(UUID uuid) {
        this.put(Binary.writeUUID(uuid));
    }

    public UUID getUUID() {
        return Binary.readUUID(this.get(16));
    }

    public void putSkin(Skin skin) {
        this.putString(skin.getSkinId());
        this.putString(skin.getPlayFabId());
        this.putString(skin.getSkinResourcePatch());
        this.putImage(skin.getSkinData());
        List<SkinAnimation> animations = skin.getAnimations();
        this.putLInt(animations.size());
        for (SkinAnimation skinAnimation : animations) {
            this.putImage(skinAnimation.image);
            this.putLInt(skinAnimation.type);
            this.putLFloat(skinAnimation.frames);
            this.putLInt(skinAnimation.expression);
        }
        this.putImage(skin.getCapeData());
        this.putString(skin.getGeometryData());
        this.putString(skin.getGeometryDataEngineVersion());
        this.putString(skin.getAnimationData());
        this.putString(skin.getCapeId());
        this.putString(skin.getFullSkinId());
        this.putString(skin.getArmSize());
        this.putString(skin.getSkinColor());
        List<PersonaPiece> pieces = skin.getPersonaPieces();
        this.putLInt(pieces.size());
        for (PersonaPiece piece : pieces) {
            this.putString(piece.id);
            this.putString(piece.type);
            this.putString(piece.packId);
            this.putBoolean(piece.isDefault);
            this.putString(piece.productId);
        }
        List<PersonaPieceTint> list = skin.getTintColors();
        this.putLInt(list.size());
        for (PersonaPieceTint tint : list) {
            this.putString(tint.pieceType);
            ImmutableList<String> colors = tint.colors;
            this.putLInt(colors.size());
            for (String color : colors) {
                this.putString(color);
            }
        }
        this.putBoolean(skin.isPremium());
        this.putBoolean(skin.isPersona());
        this.putBoolean(skin.isCapeOnClassic());
        this.putBoolean(skin.isPrimaryUser());
        this.putBoolean(skin.isOverridingPlayerAppearance());
    }

    public void putImage(SerializedImage image) {
        this.putLInt(image.width);
        this.putLInt(image.height);
        this.putByteArray(image.data);
    }

    public SerializedImage getImage() {
        int width = this.getLInt();
        int height = this.getLInt();
        byte[] data = this.getByteArray();
        return new SerializedImage(width, height, data);
    }

    public Skin getSkin() {
        Skin skin = new Skin();
        skin.setSkinId(this.getString());
        skin.setPlayFabId(this.getString());
        skin.setSkinResourcePatch(this.getString());
        skin.setSkinData(this.getImage());
        int animationCount = this.getLInt();
        for (int i = 0; i < animationCount; ++i) {
            SerializedImage image = this.getImage();
            int type = this.getLInt();
            float frames = this.getLFloat();
            int expression = this.getLInt();
            skin.getAnimations().add(new SkinAnimation(image, type, frames, expression));
        }
        skin.setCapeData(this.getImage());
        skin.setGeometryData(this.getString());
        skin.setGeometryDataEngineVersion(this.getString());
        skin.setAnimationData(this.getString());
        skin.setCapeId(this.getString());
        skin.setFullSkinId(this.getString());
        skin.setArmSize(this.getString());
        skin.setSkinColor(this.getString());
        int piecesLength = this.getLInt();
        for (int i = 0; i < piecesLength; ++i) {
            String pieceId = this.getString();
            String pieceType = this.getString();
            String packId = this.getString();
            boolean isDefault = this.getBoolean();
            String productId = this.getString();
            skin.getPersonaPieces().add(new PersonaPiece(pieceId, pieceType, packId, isDefault, productId));
        }
        int tintsLength = this.getLInt();
        for (int i = 0; i < tintsLength; ++i) {
            String pieceType = this.getString();
            ArrayList<String> colors = new ArrayList<String>();
            int colorsLength = this.getLInt();
            for (int i2 = 0; i2 < colorsLength; ++i2) {
                colors.add(this.getString());
            }
            skin.getTintColors().add(new PersonaPieceTint(pieceType, colors));
        }
        skin.setPremium(this.getBoolean());
        skin.setPersona(this.getBoolean());
        skin.setCapeOnClassic(this.getBoolean());
        skin.setPrimaryUser(this.getBoolean());
        this.getBoolean();
        return skin;
    }

    public Item getSlot() {
        String[] canBreak;
        String[] canPlace;
        int runtimeId = this.getVarInt();
        if (runtimeId == 0) {
            return Item.get(0, (Integer)0, 0);
        }
        int count = this.getLShort();
        int damage = (int)this.getUnsignedVarInt();
        RuntimeItemMapping mapping = RuntimeItems.getMapping();
        RuntimeItemMapping.LegacyEntry legacyEntry = mapping.fromRuntime(runtimeId);
        int id = legacyEntry.getLegacyId();
        if (legacyEntry.isHasDamage()) {
            damage = legacyEntry.getDamage();
        }
        if (this.getBoolean()) {
            this.getVarInt();
        }
        int blockRuntimeId = this.getVarInt();
        byte[] bytes = this.getByteArray();
        ByteBuf buf = ByteBufAllocator.DEFAULT.ioBuffer(bytes.length);
        buf.writeBytes(bytes);
        byte[] nbt = new byte[]{};
        try (LittleEndianByteBufInputStream stream = new LittleEndianByteBufInputStream(buf);){
            int canPlaceCount;
            short nbtSize = stream.readShort();
            CompoundTag compoundTag = null;
            if (nbtSize > 0) {
                compoundTag = NBTIO.read(stream, ByteOrder.LITTLE_ENDIAN);
            } else if (nbtSize == -1) {
                int tagCount = stream.readUnsignedByte();
                if (tagCount != 1) {
                    throw new IllegalArgumentException("Expected 1 tag but got " + tagCount);
                }
                compoundTag = NBTIO.read(stream, ByteOrder.LITTLE_ENDIAN);
            }
            if (compoundTag != null && !compoundTag.getAllTags().isEmpty()) {
                if (!legacyEntry.isHasDamage() && compoundTag.contains("Damage")) {
                    damage = compoundTag.getInt("Damage");
                    compoundTag.remove("Damage");
                }
                if (compoundTag.contains("__DamageConflict__")) {
                    compoundTag.put("Damage", (Tag)compoundTag.removeAndGet("__DamageConflict__"));
                }
                if (!compoundTag.isEmpty()) {
                    nbt = NBTIO.write(compoundTag, ByteOrder.LITTLE_ENDIAN);
                }
            }
            if ((canPlaceCount = stream.readInt()) > 4096) {
                throw new RuntimeException("Too many CanPlaceOn blocks: " + canPlaceCount);
            }
            canPlace = new String[canPlaceCount];
            for (int i = 0; i < canPlace.length; ++i) {
                canPlace[i] = stream.readUTF();
            }
            int canBreakCount = stream.readInt();
            if (canBreakCount > 4096) {
                throw new RuntimeException("Too many CanDestroy blocks: " + canBreakCount);
            }
            canBreak = new String[canBreakCount];
            for (int i = 0; i < canBreak.length; ++i) {
                canBreak[i] = stream.readUTF();
            }
            if (id == 513) {
                stream.readLong();
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to read item user data", e);
        }
        finally {
            buf.release();
        }
        Item item = Item.get(id, (Integer)damage, count, nbt);
        if (canBreak.length > 0 || canPlace.length > 0) {
            CompoundTag namedTag = item.getNamedTag();
            if (namedTag == null) {
                namedTag = new CompoundTag();
            }
            if (canBreak.length > 0) {
                ListTag<StringTag> listTag = new ListTag<StringTag>("CanDestroy");
                for (String blockName : canBreak) {
                    listTag.add(new StringTag("", blockName));
                }
                namedTag.put("CanDestroy", listTag);
            }
            if (canPlace.length > 0) {
                ListTag<StringTag> listTag = new ListTag<StringTag>("CanPlaceOn");
                for (String blockName : canPlace) {
                    listTag.add(new StringTag("", blockName));
                }
                namedTag.put("CanPlaceOn", listTag);
            }
            item.setNamedTag(namedTag);
        }
        return item;
    }

    public void putSlot(Item item) {
        this.putSlot(item, false);
    }

    public void putSlot(Item item, boolean instanceItem) {
        if (item == null || item.getId() == 0) {
            this.putByte((byte)0);
            return;
        }
        int id = item.getId();
        int meta = item.getDamage();
        boolean isBlock = item instanceof ItemBlock;
        boolean isDurable = item instanceof ItemDurable;
        RuntimeItemMapping mapping = RuntimeItems.getMapping();
        RuntimeItemMapping.RuntimeEntry runtimeEntry = mapping.toRuntime(id, meta);
        int runtimeId = runtimeEntry.getRuntimeId();
        int damage = isBlock || isDurable || runtimeEntry.isHasDamage() ? 0 : meta;
        this.putVarInt(runtimeId);
        this.putLShort(item.getCount());
        this.putUnsignedVarInt(damage);
        if (!instanceItem) {
            this.putBoolean(true);
            this.putVarInt(1);
        }
        Block block = isBlock ? item.getBlockUnsafe() : null;
        int blockRuntimeId = block == null ? 0 : GlobalBlockPalette.getOrCreateRuntimeId(block.getId(), block.getDamage());
        this.putVarInt(blockRuntimeId);
        ByteBuf userDataBuf = ByteBufAllocator.DEFAULT.ioBuffer();
        try (LittleEndianByteBufOutputStream stream = new LittleEndianByteBufOutputStream(userDataBuf);){
            if (!instanceItem && isDurable && !runtimeEntry.isHasDamage()) {
                byte[] nbt = item.getCompoundTag();
                CompoundTag tag = nbt == null || nbt.length == 0 ? new CompoundTag() : NBTIO.read(nbt, ByteOrder.LITTLE_ENDIAN);
                if (tag.contains("Damage")) {
                    tag.put("__DamageConflict__", (Tag)tag.removeAndGet("Damage"));
                }
                tag.putInt("Damage", meta);
                stream.writeShort(-1);
                stream.writeByte(1);
                stream.write(NBTIO.write(tag, ByteOrder.LITTLE_ENDIAN));
            } else if (item.hasCompoundTag()) {
                stream.writeShort(-1);
                stream.writeByte(1);
                stream.write(item.getCompoundTag());
            } else {
                userDataBuf.writeShortLE(0);
            }
            List<String> canPlaceOn = BinaryStream.extractStringList(item, "CanPlaceOn");
            stream.writeInt(canPlaceOn.size());
            for (String string : canPlaceOn) {
                stream.writeUTF(string);
            }
            List<String> canDestroy = BinaryStream.extractStringList(item, "CanDestroy");
            stream.writeInt(canDestroy.size());
            for (String string : canDestroy) {
                stream.writeUTF(string);
            }
            if (id == 513) {
                stream.writeLong(0L);
            }
            byte[] byArray = new byte[userDataBuf.readableBytes()];
            userDataBuf.readBytes(byArray);
            this.putByteArray(byArray);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to write item user data", e);
        }
        finally {
            userDataBuf.release();
        }
    }

    public Item getRecipeIngredient() {
        int runtimeId = this.getVarInt();
        if (runtimeId == 0) {
            return Item.get(0, (Integer)0, 0);
        }
        int damage = this.getVarInt();
        if (damage == Short.MAX_VALUE) {
            damage = -1;
        }
        RuntimeItemMapping mapping = RuntimeItems.getMapping();
        RuntimeItemMapping.LegacyEntry legacyEntry = mapping.fromRuntime(runtimeId);
        int id = legacyEntry.getLegacyId();
        if (legacyEntry.isHasDamage()) {
            damage = legacyEntry.getDamage();
        }
        int count = this.getVarInt();
        return Item.get(id, (Integer)damage, count);
    }

    public void putRecipeIngredient(Item item) {
        int runtimeId;
        if (item == null || item.getId() == 0) {
            this.putBoolean(false);
            this.putVarInt(0);
            return;
        }
        this.putBoolean(true);
        int damage = item.hasMeta() ? item.getDamage() : Short.MAX_VALUE;
        RuntimeItemMapping mapping = RuntimeItems.getMapping();
        if (!item.hasMeta()) {
            RuntimeItemMapping.RuntimeEntry runtimeEntry = mapping.toRuntime(item.getId(), 0);
            runtimeId = runtimeEntry.getRuntimeId();
            damage = Short.MAX_VALUE;
        } else {
            RuntimeItemMapping.RuntimeEntry runtimeEntry = mapping.toRuntime(item.getId(), item.getDamage());
            runtimeId = runtimeEntry.getRuntimeId();
            damage = runtimeEntry.isHasDamage() ? 0 : item.getDamage();
        }
        this.putLShort(runtimeId);
        this.putLShort(damage);
        this.putVarInt(item.getCount());
    }

    private static List<String> extractStringList(Item item, String tagName) {
        CompoundTag namedTag = item.getNamedTag();
        if (namedTag == null) {
            return Collections.emptyList();
        }
        ListTag<StringTag> listTag = namedTag.getList(tagName, StringTag.class);
        if (listTag == null) {
            return Collections.emptyList();
        }
        int size = listTag.size();
        ArrayList<String> values = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            StringTag stringTag = listTag.get(i);
            if (stringTag == null) continue;
            values.add(stringTag.data);
        }
        return values;
    }

    public byte[] getByteArray() {
        return this.get((int)this.getUnsignedVarInt());
    }

    public void putByteArray(byte[] b) {
        this.putUnsignedVarInt(b.length);
        this.put(b);
    }

    public String getString() {
        return new String(this.getByteArray(), StandardCharsets.UTF_8);
    }

    public void putString(String string) {
        byte[] b = string.getBytes(StandardCharsets.UTF_8);
        this.putByteArray(b);
    }

    public long getUnsignedVarInt() {
        return VarInt.readUnsignedVarInt(this);
    }

    public void putUnsignedVarInt(long v) {
        VarInt.writeUnsignedVarInt(this, v);
    }

    public int getVarInt() {
        return VarInt.readVarInt(this);
    }

    public void putVarInt(int v) {
        VarInt.writeVarInt(this, v);
    }

    public long getVarLong() {
        return VarInt.readVarLong(this);
    }

    public void putVarLong(long v) {
        VarInt.writeVarLong(this, v);
    }

    public long getUnsignedVarLong() {
        return VarInt.readUnsignedVarLong(this);
    }

    public void putUnsignedVarLong(long v) {
        VarInt.writeUnsignedVarLong(this, v);
    }

    public BlockVector3 getBlockVector3() {
        return new BlockVector3(this.getVarInt(), (int)this.getUnsignedVarInt(), this.getVarInt());
    }

    public BlockVector3 getSignedBlockPosition() {
        return new BlockVector3(this.getVarInt(), this.getVarInt(), this.getVarInt());
    }

    public void putSignedBlockPosition(BlockVector3 v) {
        this.putVarInt(v.x);
        this.putVarInt(v.y);
        this.putVarInt(v.z);
    }

    public void putBlockVector3(BlockVector3 v) {
        this.putBlockVector3(v.x, v.y, v.z);
    }

    public void putBlockVector3(int x, int y, int z) {
        this.putVarInt(x);
        this.putUnsignedVarInt(Integer.toUnsignedLong(y));
        this.putVarInt(z);
    }

    public Vector3f getVector3f() {
        return new Vector3f(this.getLFloat(), this.getLFloat(), this.getLFloat());
    }

    public void putVector3f(Vector3f v) {
        this.putVector3f(v.x, v.y, v.z);
    }

    public void putVector3f(float x, float y, float z) {
        this.putLFloat(x);
        this.putLFloat(y);
        this.putLFloat(z);
    }

    public Vector2f getVector2f() {
        return new Vector2f(this.getLFloat(), this.getLFloat());
    }

    public void putGameRules(GameRules gameRules) {
        HashMap<GameRule, GameRules.Value> rulesToSend = new HashMap<GameRule, GameRules.Value>(gameRules.getGameRules());
        this.putUnsignedVarInt(rulesToSend.size());
        rulesToSend.forEach((gameRule, value) -> {
            this.putString(gameRule.getName().toLowerCase());
            value.write(this);
        });
    }

    public void putGameRulesMap(Map<GameRule, GameRules.Value> allGameRules) {
        HashMap<GameRule, GameRules.Value> rulesToSend = new HashMap<GameRule, GameRules.Value>();
        allGameRules.forEach((gameRule, value) -> {
            if (gameRule == GameRule.NATURAL_REGENERATION) {
                rulesToSend.put((GameRule)((Object)gameRule), new GameRules.Value<Boolean>(GameRules.Type.BOOLEAN, false));
            } else {
                rulesToSend.put((GameRule)((Object)gameRule), (GameRules.Value)value);
            }
        });
        this.putUnsignedVarInt(rulesToSend.size());
        rulesToSend.forEach((gameRule, value) -> {
            this.putString(gameRule.getName().toLowerCase());
            value.write(this);
        });
    }

    public long getEntityUniqueId() {
        return this.getVarLong();
    }

    public void putEntityUniqueId(long eid) {
        this.putVarLong(eid);
    }

    public long getEntityRuntimeId() {
        return this.getUnsignedVarLong();
    }

    public void putEntityRuntimeId(long eid) {
        this.putUnsignedVarLong(eid);
    }

    public BlockFace getBlockFace() {
        return BlockFace.fromIndex(this.getVarInt());
    }

    public void putBlockFace(BlockFace face) {
        this.putVarInt(face.getIndex());
    }

    public void putEntityLink(EntityLink link) {
        this.putEntityUniqueId(link.fromEntityUniquieId);
        this.putEntityUniqueId(link.toEntityUniquieId);
        this.putByte(link.type);
        this.putBoolean(link.immediate);
        this.putBoolean(link.riderInitiated);
        this.putLFloat(link.vehicleAngularVelocity);
    }

    public EntityLink getEntityLink() {
        return new EntityLink(this.getEntityUniqueId(), this.getEntityUniqueId(), (byte)this.getByte(), this.getBoolean(), this.getBoolean(), this.getLFloat());
    }

    public <T> T[] getArray(Class<T> clazz, Function<BinaryStream, T> function) {
        ArrayDeque<T> deque = new ArrayDeque<T>();
        int count = (int)this.getUnsignedVarInt();
        for (int i = 0; i < count; ++i) {
            deque.add(function.apply(this));
        }
        return deque.toArray((Object[])Array.newInstance(clazz, 0));
    }

    public <T> void putArray(Collection<T> array, BiConsumer<BinaryStream, T> biConsumer) {
        this.putUnsignedVarInt(array.size());
        for (T val : array) {
            biConsumer.accept(this, (BinaryStream)val);
        }
    }

    public boolean feof() {
        return this.offset < 0 || this.offset >= this.buffer.length;
    }

    private void ensureCapacity(int minCapacity) {
        if (minCapacity - this.buffer.length > 0) {
            this.grow(minCapacity);
        }
    }

    private void grow(int minCapacity) {
        int oldCapacity = this.buffer.length;
        int newCapacity = oldCapacity << 1;
        if (newCapacity - minCapacity < 0) {
            newCapacity = minCapacity;
        }
        if (newCapacity - 0x7FFFFFF7 > 0) {
            newCapacity = BinaryStream.hugeCapacity(minCapacity);
        }
        this.buffer = Arrays.copyOf(this.buffer, newCapacity);
    }

    private static int hugeCapacity(int minCapacity) {
        if (minCapacity < 0) {
            throw new OutOfMemoryError();
        }
        return minCapacity > 0x7FFFFFF7 ? Integer.MAX_VALUE : 0x7FFFFFF7;
    }

    public <T> void putNbtTag(T tag) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try (NBTOutputStream writer = NbtUtils.createNetworkWriter(stream);){
            writer.writeTag(tag);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.put(stream.toByteArray());
    }

    public void putExperiments(Collection<ExperimentData> experiments) {
        this.putLInt(experiments.size());
        for (ExperimentData experimentData : experiments) {
            this.putString(experimentData.getName());
            this.putBoolean(experimentData.isEnabled());
        }
        this.putBoolean(!experiments.isEmpty());
    }
}

