/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.scoreboard;

import cn.nukkit.Player;
import cn.nukkit.Server;
import cn.nukkit.network.protocol.DataPacket;
import cn.nukkit.network.protocol.RemoveObjectivePacket;
import cn.nukkit.network.protocol.SetDisplayObjectivePacket;
import cn.nukkit.network.protocol.SetScorePacket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;

public class Scoreboard {
    private static final AtomicInteger SCOREBOARD_COUNT = new AtomicInteger();
    private final Set<Player> viewers = new HashSet<Player>();
    private final Map<String, Score> scores = new HashMap<String, Score>();
    private final String title;
    private final SortOrder sortOrder;
    private final DisplaySlot displaySlot;
    private final String objectiveId = String.valueOf(SCOREBOARD_COUNT.getAndIncrement());
    private long scoreId;
    private boolean isHoldingUpdates;
    private final List<QueuedScoreUpdate> queuedUpdates = new ArrayList<QueuedScoreUpdate>(0);

    public boolean setScore(String scorer, int newScore) {
        Score score = this.scores.get(scorer);
        if (score == null) {
            score = new Score(++this.scoreId, newScore);
            this.scores.put(scorer, score);
            this.sendScore(scorer, score, SetScorePacket.Action.SET);
        } else if (score.score != newScore) {
            score.score = newScore;
            this.sendScore(scorer, score, SetScorePacket.Action.SET);
            return true;
        }
        return false;
    }

    public boolean removeScore(String scorer) {
        Score oldScore = this.scores.remove(scorer);
        if (oldScore != null) {
            this.sendScore(scorer, oldScore, SetScorePacket.Action.REMOVE);
            return true;
        }
        return false;
    }

    public boolean clear() {
        if (this.scores.isEmpty()) {
            return false;
        }
        this.sendClearPacket();
        this.scores.clear();
        return true;
    }

    public boolean showTo(Player player) {
        if (this.viewers.add(player)) {
            this.sendShowPacket(player);
            return true;
        }
        return false;
    }

    public boolean hideFor(Player player) {
        if (this.viewers.remove(player)) {
            if (!player.isClosed()) {
                this.sendHidePacket(player);
            }
            return true;
        }
        return false;
    }

    public boolean holdUpdates() {
        if (this.isHoldingUpdates) {
            return false;
        }
        this.isHoldingUpdates = true;
        return true;
    }

    public boolean unholdUpdates() {
        if (!this.isHoldingUpdates) {
            return false;
        }
        this.isHoldingUpdates = false;
        SetScorePacket pk = null;
        SetScorePacket.Action lastAction = null;
        for (QueuedScoreUpdate update : this.queuedUpdates) {
            if (update.action != lastAction) {
                if (pk != null) {
                    Server.broadcastPacket(this.viewers, pk);
                }
                pk = new SetScorePacket();
            }
            lastAction = update.action;
            pk.action = update.action;
            pk.infos.add(new SetScorePacket.ScoreInfo(update.currentScoreId, this.objectiveId, update.currentScoreValue, update.scorer));
        }
        if (pk != null) {
            Server.broadcastPacket(this.viewers, pk);
        }
        this.queuedUpdates.clear();
        return true;
    }

    public Map<String, Score> getScores() {
        return Collections.unmodifiableMap(this.scores);
    }

    private void sendScore(String scorer, Score score, SetScorePacket.Action action) {
        if (this.viewers.isEmpty()) {
            return;
        }
        if (this.isHoldingUpdates) {
            this.queuedUpdates.add(new QueuedScoreUpdate(scorer, score.id, score.score, action));
            return;
        }
        SetScorePacket pk = new SetScorePacket();
        pk.action = action;
        pk.infos.add(new SetScorePacket.ScoreInfo(score.id, this.objectiveId, score.score, scorer));
        Server.broadcastPacket(this.viewers, (DataPacket)pk);
    }

    private void sendClearPacket() {
        if (this.viewers.isEmpty()) {
            return;
        }
        if (this.isHoldingUpdates) {
            for (Map.Entry<String, Score> entry : this.scores.entrySet()) {
                String scorer = entry.getKey();
                Score score = entry.getValue();
                this.queuedUpdates.add(new QueuedScoreUpdate(scorer, score.id, score.score, SetScorePacket.Action.REMOVE));
            }
            return;
        }
        SetScorePacket pk = new SetScorePacket();
        pk.action = SetScorePacket.Action.REMOVE;
        for (Map.Entry<String, Score> entry : this.scores.entrySet()) {
            String scorer = entry.getKey();
            Score score = entry.getValue();
            pk.infos.add(new SetScorePacket.ScoreInfo(score.id, this.objectiveId, score.score, scorer));
        }
        Server.broadcastPacket(this.viewers, (DataPacket)pk);
    }

    private void sendShowPacket(Player player) {
        SetDisplayObjectivePacket objectivePacket = new SetDisplayObjectivePacket();
        objectivePacket.displaySlot = this.displaySlot;
        objectivePacket.objectiveId = this.objectiveId;
        objectivePacket.displayName = this.title;
        objectivePacket.criteria = "dummy";
        objectivePacket.sortOrder = this.sortOrder;
        player.dataPacket(objectivePacket);
        SetScorePacket scorePacket = new SetScorePacket();
        scorePacket.action = SetScorePacket.Action.SET;
        for (Map.Entry<String, Score> entry : this.scores.entrySet()) {
            String scorer = entry.getKey();
            Score score = entry.getValue();
            scorePacket.infos.add(new SetScorePacket.ScoreInfo(score.id, this.objectiveId, score.score, scorer));
        }
        player.dataPacket(scorePacket);
    }

    private void sendHidePacket(Player player) {
        RemoveObjectivePacket pk = new RemoveObjectivePacket();
        pk.objectiveId = this.objectiveId;
        player.dataPacket(pk);
    }

    @Generated
    public Scoreboard(String title, SortOrder sortOrder, DisplaySlot displaySlot) {
        this.title = title;
        this.sortOrder = sortOrder;
        this.displaySlot = displaySlot;
    }

    private static class QueuedScoreUpdate {
        private final String scorer;
        private final long currentScoreId;
        private final int currentScoreValue;
        private SetScorePacket.Action action;

        @Generated
        public QueuedScoreUpdate(String scorer, long currentScoreId, int currentScoreValue, SetScorePacket.Action action) {
            this.scorer = scorer;
            this.currentScoreId = currentScoreId;
            this.currentScoreValue = currentScoreValue;
            this.action = action;
        }
    }

    public static class Score {
        private final long id;
        private int score;

        @Generated
        public Score(long id, int score) {
            this.id = id;
            this.score = score;
        }

        @Generated
        public int getScore() {
            return this.score;
        }
    }

    public static enum DisplaySlot {
        LIST("list"),
        SIDEBAR("sidebar"),
        BELOW_NAME("belowname");

        private final String type;

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        private DisplaySlot(String type) {
            this.type = type;
        }
    }

    public static enum SortOrder {
        ASCENDING,
        DESCENDING;

    }
}

