/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.resourcepacks;

import cn.nukkit.Server;
import cn.nukkit.resourcepacks.ResourcePack;
import cn.nukkit.resourcepacks.loader.ResourcePackLoader;
import cn.nukkit.resourcepacks.loader.ZippedResourcePackLoader;
import cn.nukkit.utils.MainLogger;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import lombok.Generated;

public class ResourcePackManager {
    private int maxChunkSize = 32768;
    private final Map<UUID, ResourcePack> resourcePacksById = new HashMap<UUID, ResourcePack>();
    private final Set<ResourcePack> resourcePacks = new HashSet<ResourcePack>();
    private final Set<ResourcePackLoader> loaders;

    public ResourcePackManager(Set<ResourcePackLoader> loaders) {
        this.loaders = loaders;
        this.reloadPacks();
    }

    public ResourcePackManager(ResourcePackLoader ... loaders) {
        this(Sets.newHashSet(loaders));
    }

    public ResourcePackManager(File resourcePacksDir) {
        this(new ZippedResourcePackLoader(resourcePacksDir));
    }

    public ResourcePack[] getResourceStack() {
        return this.resourcePacks.toArray(ResourcePack.EMPTY_ARRAY);
    }

    public ResourcePack getPackById(UUID id) {
        return this.resourcePacksById.get(id);
    }

    public void registerPackLoader(ResourcePackLoader loader) {
        this.loaders.add(loader);
    }

    public void reloadPacks() {
        MainLogger.getLogger().debug("Loading resource packs...");
        this.resourcePacksById.clear();
        this.resourcePacks.clear();
        this.loaders.forEach(loader -> {
            List<ResourcePack> loadedPacks = loader.loadPacks();
            loadedPacks.forEach(pack -> this.resourcePacksById.put(pack.getPackId(), (ResourcePack)pack));
            this.resourcePacks.addAll(loadedPacks);
        });
        Server.getInstance().getLogger().info(Server.getInstance().getLanguage().translateString("nukkit.resources.success", String.valueOf(this.resourcePacks.size())));
    }

    @Generated
    public int getMaxChunkSize() {
        return this.maxChunkSize;
    }

    @Generated
    public void setMaxChunkSize(int maxChunkSize) {
        this.maxChunkSize = maxChunkSize;
    }
}

