/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.resourcepacks;

import cn.nukkit.Server;
import cn.nukkit.resourcepacks.AbstractResourcePack;
import com.google.gson.JsonParser;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.annotation.Nullable;
import org.jline.utils.InputStreamReader;

public class JarPluginResourcePack
extends AbstractResourcePack {
    public static final String RESOURCE_PACK_PATH = "assets/resource_pack/";
    protected File jarPluginFile;
    protected ByteBuffer zippedByteBuffer;
    protected byte[] sha256;
    protected String encryptionKey = "";

    public static boolean hasResourcePack(File jarPluginFile) {
        try {
            return JarPluginResourcePack.findManifestInJar(new ZipFile(jarPluginFile)) != null;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Nullable
    protected static ZipEntry findManifestInJar(ZipFile jar) {
        ZipEntry manifest = jar.getEntry("assets/resource_pack/manifest.json");
        if (manifest == null) {
            manifest = jar.stream().filter(e -> e.getName().toLowerCase(Locale.ENGLISH).endsWith("manifest.json") && !e.isDirectory()).filter(e -> {
                File fe = new File(e.getName());
                if (!fe.getName().equalsIgnoreCase("manifest.json")) {
                    return false;
                }
                return fe.getParent() == null || fe.getParentFile().getParent() == null;
            }).findFirst().orElse(null);
        }
        return manifest;
    }

    public JarPluginResourcePack(File jarPluginFile) {
        if (!jarPluginFile.exists()) {
            throw new IllegalArgumentException(Server.getInstance().getLanguage().translateString("nukkit.resources.zip.not-found", jarPluginFile.getName()));
        }
        this.jarPluginFile = jarPluginFile;
        try {
            ZipFile jar = new ZipFile(jarPluginFile);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ZipOutputStream zipOutputStream = new ZipOutputStream(byteArrayOutputStream);
            ZipEntry manifest = JarPluginResourcePack.findManifestInJar(jar);
            if (manifest == null) {
                throw new IllegalArgumentException(Server.getInstance().getLanguage().translateString("nukkit.resources.zip.no-manifest"));
            }
            this.manifest = JsonParser.parseReader(new InputStreamReader(jar.getInputStream(manifest), StandardCharsets.UTF_8)).getAsJsonObject();
            ZipEntry encryptionKeyEntry = jar.getEntry("assets/resource_pack/encryption.key");
            if (encryptionKeyEntry != null) {
                this.encryptionKey = new String(JarPluginResourcePack.readAllBytes(jar, encryptionKeyEntry), StandardCharsets.UTF_8);
                Server.getInstance().getLogger().debug(this.encryptionKey);
            }
            jar.stream().forEach(entry -> {
                if (entry.getName().startsWith(RESOURCE_PACK_PATH) && !entry.isDirectory() && !entry.getName().equals("assets/resource_pack/encryption.key")) {
                    try {
                        zipOutputStream.putNextEntry(new ZipEntry(entry.getName().substring(RESOURCE_PACK_PATH.length())));
                        zipOutputStream.write(JarPluginResourcePack.readAllBytes(jar, entry));
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
            jar.close();
            zipOutputStream.close();
            byteArrayOutputStream.close();
            this.zippedByteBuffer = ByteBuffer.allocateDirect(byteArrayOutputStream.size());
            byte[] bytes = byteArrayOutputStream.toByteArray();
            this.zippedByteBuffer.put(bytes);
            this.zippedByteBuffer.flip();
            try {
                this.sha256 = MessageDigest.getInstance("SHA-256").digest(bytes);
            }
            catch (Exception e) {
                Server.getInstance().getLogger().error("Failed to parse the SHA-256 of the resource pack inside of jar plugin " + jarPluginFile.getName(), e);
            }
        }
        catch (IOException e) {
            Server.getInstance().getLogger().error("An error occurred while loading the resource pack inside of a jar plugin " + jarPluginFile, e);
        }
        if (!this.verifyManifest()) {
            throw new IllegalArgumentException(Server.getInstance().getLanguage().translateString("nukkit.resources.zip.invalid-manifest"));
        }
    }

    @Override
    public int getPackSize() {
        return this.zippedByteBuffer.limit();
    }

    @Override
    public byte[] getSha256() {
        return this.sha256;
    }

    @Override
    public String getEncryptionKey() {
        return this.encryptionKey;
    }

    @Override
    public byte[] getPackChunk(int off, int len) {
        byte[] chunk = this.getPackSize() - off > len ? new byte[len] : new byte[this.getPackSize() - off];
        try {
            this.zippedByteBuffer.position(off);
            this.zippedByteBuffer.get(chunk);
        }
        catch (Exception e) {
            Server.getInstance().getLogger().error("An error occurred while processing the resource pack " + this.getPackName() + " at offset:" + off + " and length: " + len, e);
        }
        return chunk;
    }

    private static byte[] readAllBytes(ZipFile jar, ZipEntry encryptionKeyEntry) {
        byte[] data = null;
        try (InputStream is = jar.getInputStream(encryptionKeyEntry);){
            int nRead;
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] temp = new byte[2048];
            while ((nRead = is.read(temp, 0, temp.length)) != -1) {
                buffer.write(temp, 0, nRead);
            }
            data = buffer.toByteArray();
            buffer.close();
        }
        catch (IOException e) {
            Server.getInstance().getLogger().error("An error occurred while reading ZipFile", e);
        }
        return data;
    }
}

