/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.resourcepacks;

import cn.nukkit.resourcepacks.ResourcePack;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.UUID;

public abstract class AbstractResourcePack
implements ResourcePack {
    protected JsonObject manifest;
    protected UUID id;

    @Override
    public String getPackName() {
        return this.manifest.getAsJsonObject("header").get("name").getAsString();
    }

    @Override
    public UUID getPackId() {
        if (this.id == null) {
            this.id = UUID.fromString(this.manifest.getAsJsonObject("header").get("uuid").getAsString());
        }
        return this.id;
    }

    @Override
    public String getPackVersion() {
        JsonArray version = this.manifest.getAsJsonObject("header").get("version").getAsJsonArray();
        return String.join((CharSequence)".", version.get(0).getAsString(), version.get(1).getAsString(), version.get(2).getAsString());
    }

    protected boolean verifyManifest() {
        if (this.manifest.has("format_version") && this.manifest.has("header") && this.manifest.has("modules")) {
            JsonObject header = this.manifest.getAsJsonObject("header");
            return header.has("description") && header.has("name") && header.has("uuid") && header.has("version") && header.getAsJsonArray("version").size() == 3;
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ResourcePack)) {
            return false;
        }
        ResourcePack anotherPack = (ResourcePack)obj;
        return this.id.equals(anotherPack.getPackId());
    }
}

