/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.plugin;

import cn.nukkit.permission.Permission;
import cn.nukkit.plugin.PluginLoadOrder;
import cn.nukkit.utils.PluginException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class PluginDescription {
    private String name;
    private String main;
    private List<String> api;
    private List<String> depend = new ArrayList<String>();
    private List<String> softDepend = new ArrayList<String>();
    private List<String> loadBefore = new ArrayList<String>();
    private String version;
    private Map<String, Object> commands = new HashMap<String, Object>();
    private String description;
    private final List<String> authors = new ArrayList<String>();
    private String website;
    private String prefix;
    private PluginLoadOrder order = PluginLoadOrder.POSTWORLD;
    private List<Permission> permissions = new ArrayList<Permission>();
    private static final Pattern FILTER = Pattern.compile("[^A-Za-z0-9 _.-]");

    public PluginDescription(Map<String, Object> yamlMap) {
        this.loadMap(yamlMap);
    }

    public PluginDescription(String yamlString) {
        DumperOptions dumperOptions = new DumperOptions();
        dumperOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        Yaml yaml = new Yaml(dumperOptions);
        this.loadMap(yaml.loadAs(yamlString, LinkedHashMap.class));
    }

    private void loadMap(Map<String, Object> plugin) throws PluginException {
        this.name = FILTER.matcher((String)plugin.get("name")).replaceAll("");
        if (this.name.isEmpty()) {
            throw new PluginException("plugin.yml must contain 'name'");
        }
        this.name = this.name.replace(" ", "_");
        this.version = String.valueOf(plugin.get("version"));
        this.main = (String)plugin.get("main");
        Object api = plugin.get("api");
        if (api instanceof List) {
            this.api = (List)api;
        } else {
            ArrayList<String> list = new ArrayList<String>();
            list.add((String)api);
            this.api = list;
        }
        if (this.main.startsWith("cn.nukkit.")) {
            throw new PluginException(this.name + " has an invalid 'main' in plugin.yml (plugins can't be in cn.nukkit): " + this.main);
        }
        if (plugin.containsKey("commands") && plugin.get("commands") instanceof Map) {
            this.commands = (Map)plugin.get("commands");
        }
        if (plugin.containsKey("depend")) {
            this.depend = (List)plugin.get("depend");
        }
        if (plugin.containsKey("softdepend")) {
            this.softDepend = (List)plugin.get("softdepend");
        }
        if (plugin.containsKey("loadbefore")) {
            this.loadBefore = (List)plugin.get("loadbefore");
        }
        if (plugin.containsKey("website")) {
            this.website = (String)plugin.get("website");
        }
        if (plugin.containsKey("description")) {
            this.description = (String)plugin.get("description");
        }
        if (plugin.containsKey("prefix")) {
            this.prefix = (String)plugin.get("prefix");
        }
        if (plugin.containsKey("load")) {
            String order = (String)plugin.get("load");
            try {
                this.order = PluginLoadOrder.valueOf(order);
            }
            catch (Exception e) {
                throw new PluginException(this.name + " has an invalid 'load' in plugin.yml: " + order);
            }
        }
        if (plugin.containsKey("author")) {
            this.authors.add((String)plugin.get("author"));
        }
        if (plugin.containsKey("authors")) {
            this.authors.addAll((Collection)plugin.get("authors"));
        }
        if (plugin.containsKey("permissions")) {
            this.permissions = Permission.loadPermissions((Map)plugin.get("permissions"));
        }
    }

    public String getFullName() {
        return this.name + " v" + this.version;
    }

    public List<String> getCompatibleAPIs() {
        return this.api;
    }

    public List<String> getAuthors() {
        return this.authors;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public Map<String, Object> getCommands() {
        return this.commands;
    }

    public List<String> getDepend() {
        return this.depend;
    }

    public String getDescription() {
        return this.description;
    }

    public List<String> getLoadBefore() {
        return this.loadBefore;
    }

    public String getMain() {
        return this.main;
    }

    public String getName() {
        return this.name;
    }

    public PluginLoadOrder getOrder() {
        return this.order;
    }

    public List<Permission> getPermissions() {
        return this.permissions;
    }

    public List<String> getSoftDepend() {
        return this.softDepend;
    }

    public String getVersion() {
        return this.version;
    }

    public String getWebsite() {
        return this.website;
    }
}

