/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.permission;

import cn.nukkit.Server;
import cn.nukkit.permission.Permissible;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Permission {
    public static final String DEFAULT_OP = "op";
    public static final String DEFAULT_NOT_OP = "notop";
    public static final String DEFAULT_TRUE = "true";
    public static final String DEFAULT_FALSE = "false";
    public static final String DEFAULT_PERMISSION = "op";
    private final String name;
    private String description;
    private final Map<String, Boolean> children;
    private String defaultValue;

    public static String getByName(String value) {
        switch (value.toLowerCase()) {
            case "op": 
            case "isop": 
            case "operator": 
            case "isoperator": 
            case "admin": 
            case "isadmin": {
                return "op";
            }
            case "!op": 
            case "notop": 
            case "!operator": 
            case "notoperator": 
            case "!admin": 
            case "notadmin": {
                return DEFAULT_NOT_OP;
            }
            case "true": {
                return DEFAULT_TRUE;
            }
        }
        return DEFAULT_FALSE;
    }

    public Permission(String name) {
        this(name, null, null, new HashMap<String, Boolean>());
    }

    public Permission(String name, String description) {
        this(name, description, null, new HashMap<String, Boolean>());
    }

    public Permission(String name, String description, String defualtValue) {
        this(name, description, defualtValue, new HashMap<String, Boolean>());
    }

    public Permission(String name, String description, String defualtValue, Map<String, Boolean> children) {
        this.name = name;
        this.description = description != null ? description : "";
        this.defaultValue = defualtValue != null ? defualtValue : "op";
        this.children = children;
        this.recalculatePermissibles();
    }

    public String getName() {
        return this.name;
    }

    public Map<String, Boolean> getChildren() {
        return this.children;
    }

    public String getDefault() {
        return this.defaultValue;
    }

    public void setDefault(String value) {
        if (!value.equals(this.defaultValue)) {
            this.defaultValue = value;
            this.recalculatePermissibles();
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Set<Permissible> getPermissibles() {
        return Server.getInstance().getPluginManager().getPermissionSubscriptions(this.name);
    }

    public void recalculatePermissibles() {
        Set<Permissible> perms = this.getPermissibles();
        Server.getInstance().getPluginManager().recalculatePermissionDefaults(this);
        for (Permissible p : perms) {
            p.recalculatePermissions();
        }
    }

    public void addParent(Permission permission, boolean value) {
        this.children.put(this.name, value);
        permission.recalculatePermissibles();
    }

    public Permission addParent(String name, boolean value) {
        Permission perm = Server.getInstance().getPluginManager().getPermission(name);
        if (perm == null) {
            perm = new Permission(name);
            Server.getInstance().getPluginManager().addPermission(perm);
        }
        this.addParent(perm, value);
        return perm;
    }

    public static List<Permission> loadPermissions(Map<String, Object> data) {
        return Permission.loadPermissions(data, "op");
    }

    public static List<Permission> loadPermissions(Map<String, Object> data, String defaultValue) {
        ArrayList<Permission> result = new ArrayList<Permission>();
        if (data != null) {
            for (Map.Entry<String, Object> e : data.entrySet()) {
                String key = e.getKey();
                Map entry = (Map)e.getValue();
                result.add(Permission.loadPermission(key, entry, defaultValue, result));
            }
        }
        return result;
    }

    public static Permission loadPermission(String name, Map<String, Object> data) {
        return Permission.loadPermission(name, data, "op", new ArrayList<Permission>());
    }

    public static Permission loadPermission(String name, Map<String, Object> data, String defaultValue) {
        return Permission.loadPermission(name, data, defaultValue, new ArrayList<Permission>());
    }

    public static Permission loadPermission(String name, Map<String, Object> data, String defaultValue, List<Permission> output) {
        String desc = null;
        HashMap<String, Boolean> children = new HashMap<String, Boolean>();
        if (data.containsKey("default")) {
            String value = Permission.getByName(String.valueOf(data.get("default")));
            if (value != null) {
                defaultValue = value;
            } else {
                throw new IllegalStateException("'default' key contained unknown value");
            }
        }
        if (data.containsKey("children")) {
            if (data.get("children") instanceof Map) {
                for (Map.Entry entry : ((Map)data.get("children")).entrySet()) {
                    String k = (String)entry.getKey();
                    Object v = entry.getValue();
                    if (v instanceof Map) {
                        Permission permission = Permission.loadPermission(k, (Map)v, defaultValue, output);
                        output.add(permission);
                    }
                    children.put(k, true);
                }
            } else {
                throw new IllegalStateException("'children' key is of wrong type");
            }
        }
        if (data.containsKey("description")) {
            desc = (String)data.get("description");
        }
        return new Permission(name, desc, defaultValue, children);
    }
}

