/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.network.query;

import cn.nukkit.Server;
import cn.nukkit.event.server.QueryRegenerateEvent;
import cn.nukkit.utils.Utils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;

public class QueryHandler {
    private static final byte HANDSHAKE = 9;
    private static final byte STATISTICS = 0;
    private final Server server = Server.getInstance();
    private byte[] lastToken;
    private byte[] token;
    private byte[] longData;
    private byte[] shortData;
    private long timeout;

    public QueryHandler() {
        this.server.getLogger().info(this.server.getLanguage().translateString("nukkit.server.query.start"));
        String ip = this.server.getIp();
        String addr = !ip.isEmpty() ? ip : "0.0.0.0";
        int port = this.server.getPort();
        this.server.getLogger().info(this.server.getLanguage().translateString("nukkit.server.query.info", String.valueOf(port)));
        this.regenerateToken();
        this.lastToken = this.token;
        this.regenerateInfo();
        this.server.getLogger().info(this.server.getLanguage().translateString("nukkit.server.query.running", new String[]{addr, String.valueOf(port)}));
    }

    public void regenerateInfo() {
        QueryRegenerateEvent ev = this.server.getQueryInformation();
        this.longData = ev.getLongQuery();
        this.shortData = ev.getShortQuery();
        this.timeout = System.currentTimeMillis() + (long)ev.getTimeout();
    }

    public void regenerateToken() {
        this.lastToken = this.token;
        byte[] token = new byte[16];
        for (int i = 0; i < 16; ++i) {
            token[i] = (byte)Utils.random.nextInt(255);
        }
        this.token = token;
    }

    public static byte[] getTokenString(String token, InetAddress address) {
        return QueryHandler.getTokenString(token.getBytes(StandardCharsets.UTF_8), address);
    }

    public static byte[] getTokenString(byte[] token, InetAddress address) {
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            digest.update(address.toString().getBytes(StandardCharsets.UTF_8));
            digest.update(token);
            return Arrays.copyOf(digest.digest(), 4);
        }
        catch (NoSuchAlgorithmException e) {
            return ByteBuffer.allocate(4).putInt(Utils.random.nextInt()).array();
        }
    }

    public void handle(InetSocketAddress address, ByteBuf packet) {
        short packetId = packet.readUnsignedByte();
        int sessionId = packet.readInt();
        switch (packetId) {
            case 9: {
                ByteBuf reply = ByteBufAllocator.DEFAULT.ioBuffer(10);
                reply.writeByte(9);
                reply.writeInt(sessionId);
                reply.writeBytes(QueryHandler.getTokenString(this.token, address.getAddress()));
                reply.writeByte(0);
                this.server.getNetwork().sendPacket(address, reply);
                break;
            }
            case 0: {
                byte[] token = new byte[4];
                packet.readBytes(token);
                if (!Arrays.equals(token, QueryHandler.getTokenString(this.token, address.getAddress())) && !Arrays.equals(token, QueryHandler.getTokenString(this.lastToken, address.getAddress()))) break;
                if (this.timeout < System.currentTimeMillis()) {
                    this.regenerateInfo();
                }
                ByteBuf reply = ByteBufAllocator.DEFAULT.directBuffer(64);
                reply.writeByte(0);
                reply.writeInt(sessionId);
                if (packet.readableBytes() == 8) {
                    reply.writeBytes(this.longData);
                } else {
                    reply.writeBytes(this.shortData);
                }
                this.server.getNetwork().sendPacket(address, reply);
            }
        }
    }
}

