/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.network.protocol;

import cn.nukkit.network.protocol.DataPacket;
import cn.nukkit.network.protocol.types.AbilityLayer;
import cn.nukkit.network.protocol.types.PlayerAbility;
import cn.nukkit.utils.BinaryStream;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Set;
import lombok.Generated;

public class UpdateAbilitiesPacket
extends DataPacket {
    public static final byte NETWORK_ID = -69;
    protected static final PlayerAbility[] VALID_FLAGS = new PlayerAbility[]{PlayerAbility.BUILD, PlayerAbility.MINE, PlayerAbility.DOORS_AND_SWITCHES, PlayerAbility.OPEN_CONTAINERS, PlayerAbility.ATTACK_PLAYERS, PlayerAbility.ATTACK_MOBS, PlayerAbility.OPERATOR_COMMANDS, PlayerAbility.TELEPORT, PlayerAbility.INVULNERABLE, PlayerAbility.FLYING, PlayerAbility.MAY_FLY, PlayerAbility.INSTABUILD, PlayerAbility.LIGHTNING, PlayerAbility.FLY_SPEED, PlayerAbility.WALK_SPEED, PlayerAbility.MUTED, PlayerAbility.WORLD_BUILDER, PlayerAbility.NO_CLIP, PlayerAbility.PRIVILEGED_BUILDER};
    private static final EnumMap<PlayerAbility, Integer> FLAGS_TO_BITS = new EnumMap(PlayerAbility.class);
    private long entityId;
    private PlayerPermission playerPermission;
    private CommandPermission commandPermission;
    private final List<AbilityLayer> abilityLayers = new ObjectArrayList<AbilityLayer>(2);

    @Override
    public void decode() {
        this.decodeUnsupported();
    }

    @Override
    public void encode() {
        this.reset();
        this.putLLong(this.entityId);
        this.putUnsignedVarInt(this.playerPermission.ordinal());
        this.putUnsignedVarInt(this.commandPermission.ordinal());
        this.putArray(this.abilityLayers, this::writeAbilityLayer);
    }

    private void writeAbilityLayer(BinaryStream buffer, AbilityLayer abilityLayer) {
        buffer.putLShort(abilityLayer.getLayerType().ordinal());
        buffer.putLInt(UpdateAbilitiesPacket.getAbilitiesNumber(abilityLayer.getAbilitiesSet()));
        buffer.putLInt(UpdateAbilitiesPacket.getAbilitiesNumber(abilityLayer.getAbilityValues()));
        buffer.putLFloat(abilityLayer.getFlySpeed());
        buffer.putLFloat(abilityLayer.getWalkSpeed());
    }

    private static int getAbilitiesNumber(Set<PlayerAbility> abilities) {
        int number = 0;
        for (PlayerAbility ability : abilities) {
            number |= FLAGS_TO_BITS.getOrDefault((Object)ability, 0).intValue();
        }
        return number;
    }

    @Override
    public byte pid() {
        return -69;
    }

    @Generated
    public String toString() {
        return "UpdateAbilitiesPacket(entityId=" + this.getEntityId() + ", playerPermission=" + (Object)((Object)this.getPlayerPermission()) + ", commandPermission=" + (Object)((Object)this.getCommandPermission()) + ", abilityLayers=" + this.getAbilityLayers() + ")";
    }

    @Generated
    public long getEntityId() {
        return this.entityId;
    }

    @Generated
    public PlayerPermission getPlayerPermission() {
        return this.playerPermission;
    }

    @Generated
    public CommandPermission getCommandPermission() {
        return this.commandPermission;
    }

    @Generated
    public List<AbilityLayer> getAbilityLayers() {
        return this.abilityLayers;
    }

    @Generated
    public void setEntityId(long entityId) {
        this.entityId = entityId;
    }

    @Generated
    public void setPlayerPermission(PlayerPermission playerPermission) {
        this.playerPermission = playerPermission;
    }

    @Generated
    public void setCommandPermission(CommandPermission commandPermission) {
        this.commandPermission = commandPermission;
    }

    static {
        for (int i = 0; i < VALID_FLAGS.length; ++i) {
            FLAGS_TO_BITS.put(VALID_FLAGS[i], 1 << i);
        }
    }

    public static enum CommandPermission {
        NORMAL,
        OPERATOR,
        HOST,
        AUTOMATION,
        ADMIN;

    }

    public static enum PlayerPermission {
        VISITOR,
        MEMBER,
        OPERATOR,
        CUSTOM;

    }
}

