/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.network.protocol;

import cn.nukkit.network.protocol.DataPacket;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import lombok.Generated;

public class SetScorePacket
extends DataPacket {
    public static final byte NETWORK_ID = 108;
    public Action action;
    public final List<ScoreInfo> infos = new ObjectArrayList<ScoreInfo>();

    @Override
    public byte pid() {
        return 108;
    }

    @Override
    public void decode() {
        this.decodeUnsupported();
    }

    @Override
    public void encode() {
        this.reset();
        this.putByte((byte)this.action.ordinal());
        this.putUnsignedVarInt(this.infos.size());
        block4: for (ScoreInfo info : this.infos) {
            this.putVarLong(info.scoreboardId);
            this.putString(info.objectiveId);
            this.putLInt(info.score);
            if (this.action != Action.SET) continue;
            this.putByte((byte)info.type.ordinal());
            switch (info.type) {
                case PLAYER: 
                case ENTITY: {
                    this.putEntityUniqueId(info.entityId);
                    continue block4;
                }
                case FAKE: {
                    this.putString(info.name);
                    continue block4;
                }
            }
            throw new IllegalArgumentException("Invalid score info type");
        }
    }

    @Generated
    public String toString() {
        return "SetScorePacket(action=" + (Object)((Object)this.action) + ", infos=" + this.infos + ")";
    }

    public static class ScoreInfo {
        private final long scoreboardId;
        private final String objectiveId;
        private final int score;
        private final ScorerType type;
        private final String name;
        private final long entityId;

        public ScoreInfo(long scoreboardId, String objectiveId, int score, String name) {
            this.scoreboardId = scoreboardId;
            this.objectiveId = objectiveId;
            this.score = score;
            this.type = ScorerType.FAKE;
            this.name = name;
            this.entityId = -1L;
        }

        public ScoreInfo(long scoreboardId, String objectiveId, int score, ScorerType type, long entityId) {
            if (type != ScorerType.PLAYER && type != ScorerType.ENTITY) {
                throw new IllegalArgumentException("Scorer type must be either PLAYER or ENTITY");
            }
            this.scoreboardId = scoreboardId;
            this.objectiveId = objectiveId;
            this.score = score;
            this.type = type;
            this.name = null;
            this.entityId = entityId;
        }

        @Generated
        public long getScoreboardId() {
            return this.scoreboardId;
        }

        @Generated
        public String getObjectiveId() {
            return this.objectiveId;
        }

        @Generated
        public int getScore() {
            return this.score;
        }

        @Generated
        public ScorerType getType() {
            return this.type;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public long getEntityId() {
            return this.entityId;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ScoreInfo)) {
                return false;
            }
            ScoreInfo other = (ScoreInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getScoreboardId() != other.getScoreboardId()) {
                return false;
            }
            if (this.getScore() != other.getScore()) {
                return false;
            }
            if (this.getEntityId() != other.getEntityId()) {
                return false;
            }
            String this$objectiveId = this.getObjectiveId();
            String other$objectiveId = other.getObjectiveId();
            if (this$objectiveId == null ? other$objectiveId != null : !this$objectiveId.equals(other$objectiveId)) {
                return false;
            }
            ScorerType this$type = this.getType();
            ScorerType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ScoreInfo;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $scoreboardId = this.getScoreboardId();
            result = result * 59 + (int)($scoreboardId >>> 32 ^ $scoreboardId);
            result = result * 59 + this.getScore();
            long $entityId = this.getEntityId();
            result = result * 59 + (int)($entityId >>> 32 ^ $entityId);
            String $objectiveId = this.getObjectiveId();
            result = result * 59 + ($objectiveId == null ? 43 : $objectiveId.hashCode());
            ScorerType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "SetScorePacket.ScoreInfo(scoreboardId=" + this.getScoreboardId() + ", objectiveId=" + this.getObjectiveId() + ", score=" + this.getScore() + ", type=" + (Object)((Object)this.getType()) + ", name=" + this.getName() + ", entityId=" + this.getEntityId() + ")";
        }

        public static enum ScorerType {
            INVALID,
            PLAYER,
            ENTITY,
            FAKE;

        }
    }

    public static enum Action {
        SET,
        REMOVE;

    }
}

