/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.network.protocol;

import cn.nukkit.network.protocol.DataPacket;
import cn.nukkit.resourcepacks.ResourcePack;
import java.util.Arrays;
import java.util.UUID;
import lombok.Generated;

public class ResourcePacksInfoPacket
extends DataPacket {
    public static final byte NETWORK_ID = 6;
    public boolean mustAccept;
    public boolean scripting;
    public boolean hasAddonPacks;
    public UUID worldTemplateId = new UUID(0L, 0L);
    public String worldTemplateVersion = "";
    public ResourcePack[] behaviourPackEntries = ResourcePack.EMPTY_ARRAY;
    public ResourcePack[] resourcePackEntries = ResourcePack.EMPTY_ARRAY;

    @Override
    public void decode() {
        this.decodeUnsupported();
    }

    @Override
    public void encode() {
        this.reset();
        this.putBoolean(this.mustAccept);
        this.putBoolean(this.hasAddonPacks);
        this.putBoolean(this.scripting);
        this.putUUID(this.worldTemplateId);
        this.putString(this.worldTemplateVersion);
        this.encodeResourcePacks(this.resourcePackEntries);
    }

    private void encodeResourcePacks(ResourcePack[] packs) {
        this.putLShort(packs.length);
        for (ResourcePack entry : packs) {
            this.putUUID(entry.getPackId());
            this.putString(entry.getPackVersion());
            this.putLLong(entry.getPackSize());
            this.putString(entry.getEncryptionKey());
            this.putString(entry.getSubPackName());
            this.putString(!entry.getEncryptionKey().isEmpty() ? entry.getPackId().toString() : "");
            this.putBoolean(entry.usesScripting());
            this.putBoolean(entry.isAddonPack());
            this.putBoolean(entry.isRaytracingCapable());
            this.putString(entry.getCDNUrl());
        }
    }

    @Override
    public byte pid() {
        return 6;
    }

    @Generated
    public String toString() {
        return "ResourcePacksInfoPacket(mustAccept=" + this.mustAccept + ", scripting=" + this.scripting + ", hasAddonPacks=" + this.hasAddonPacks + ", worldTemplateId=" + this.worldTemplateId + ", worldTemplateVersion=" + this.worldTemplateVersion + ", behaviourPackEntries=" + Arrays.deepToString(this.behaviourPackEntries) + ", resourcePackEntries=" + Arrays.deepToString(this.resourcePackEntries) + ")";
    }
}

