/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.network.protocol;

import cn.nukkit.network.protocol.DataPacket;
import cn.nukkit.network.protocol.types.ExperimentData;
import cn.nukkit.resourcepacks.ResourcePack;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;

public class ResourcePackStackPacket
extends DataPacket {
    public static final byte NETWORK_ID = 7;
    public boolean mustAccept;
    public String gameVersion = "1.21.50";
    public ResourcePack[] behaviourPackStack = ResourcePack.EMPTY_ARRAY;
    public ResourcePack[] resourcePackStack = ResourcePack.EMPTY_ARRAY;
    public final List<ExperimentData> experiments = new ObjectArrayList<ExperimentData>(1);

    @Override
    public void decode() {
        this.decodeUnsupported();
    }

    @Override
    public void encode() {
        this.reset();
        this.putBoolean(this.mustAccept);
        this.putUnsignedVarInt(this.behaviourPackStack.length);
        for (ResourcePack entry : this.behaviourPackStack) {
            this.putString(entry.getPackId().toString());
            this.putString(entry.getPackVersion());
            this.putString("");
        }
        this.putUnsignedVarInt(this.resourcePackStack.length);
        for (ResourcePack entry : this.resourcePackStack) {
            this.putString(entry.getPackId().toString());
            this.putString(entry.getPackVersion());
            this.putString("");
        }
        this.putString(this.gameVersion);
        this.putExperiments(this.experiments);
        this.putBoolean(false);
    }

    @Override
    public byte pid() {
        return 7;
    }

    @Generated
    public String toString() {
        return "ResourcePackStackPacket(mustAccept=" + this.mustAccept + ", gameVersion=" + this.gameVersion + ", behaviourPackStack=" + Arrays.deepToString(this.behaviourPackStack) + ", resourcePackStack=" + Arrays.deepToString(this.resourcePackStack) + ", experiments=" + this.experiments + ")";
    }
}

