/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.network.protocol;

import cn.nukkit.entity.data.Skin;
import cn.nukkit.network.protocol.DataPacket;
import java.util.Arrays;
import java.util.UUID;
import lombok.Generated;

public class PlayerListPacket
extends DataPacket {
    public static final byte NETWORK_ID = 63;
    public static final byte TYPE_ADD = 0;
    public static final byte TYPE_REMOVE = 1;
    public byte type;
    public Entry[] entries = new Entry[0];

    @Override
    public void decode() {
        this.decodeUnsupported();
    }

    @Override
    public void encode() {
        this.reset();
        this.putByte(this.type);
        this.putUnsignedVarInt(this.entries.length);
        switch (this.type) {
            case 0: {
                for (Entry entry : this.entries) {
                    this.putUUID(entry.uuid);
                    this.putVarLong(entry.entityId);
                    this.putString(entry.name);
                    this.putString(entry.xboxUserId);
                    this.putString(entry.platformChatId);
                    this.putLInt(entry.buildPlatform);
                    this.putSkin(entry.skin);
                    this.putBoolean(entry.isTeacher);
                    this.putBoolean(entry.isHost);
                    this.putBoolean(entry.isSubClient);
                }
                for (Entry entry : this.entries) {
                    this.putBoolean(entry.skin.isTrusted());
                }
                break;
            }
            case 1: {
                for (Entry entry : this.entries) {
                    this.putUUID(entry.uuid);
                }
                break;
            }
        }
    }

    @Override
    public byte pid() {
        return 63;
    }

    @Generated
    public String toString() {
        return "PlayerListPacket(type=" + this.type + ", entries=" + Arrays.deepToString(this.entries) + ")";
    }

    public static class Entry {
        public final UUID uuid;
        public long entityId = 0L;
        public String name = "";
        public Skin skin;
        public String xboxUserId = "";
        public String platformChatId = "";
        public int buildPlatform = -1;
        public boolean isTeacher;
        public boolean isHost;
        public boolean isSubClient;

        public Entry(UUID uuid) {
            this.uuid = uuid;
        }

        public Entry(UUID uuid, long entityId, String name, Skin skin) {
            this(uuid, entityId, name, skin, "");
        }

        public Entry(UUID uuid, long entityId, String name, Skin skin, String xboxUserId) {
            this.uuid = uuid;
            this.entityId = entityId;
            this.name = name;
            this.skin = skin;
            this.xboxUserId = xboxUserId == null ? "" : xboxUserId;
        }

        @Generated
        public String toString() {
            return "PlayerListPacket.Entry(uuid=" + this.uuid + ", entityId=" + this.entityId + ", name=" + this.name + ", skin=" + this.skin + ", xboxUserId=" + this.xboxUserId + ", platformChatId=" + this.platformChatId + ", buildPlatform=" + this.buildPlatform + ", isTeacher=" + this.isTeacher + ", isHost=" + this.isHost + ", isSubClient=" + this.isSubClient + ")";
        }
    }
}

