/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.network.protocol;

import cn.nukkit.math.Vector2;
import cn.nukkit.math.Vector2f;
import cn.nukkit.math.Vector3f;
import cn.nukkit.network.protocol.DataPacket;
import cn.nukkit.network.protocol.types.AuthInputAction;
import cn.nukkit.network.protocol.types.AuthInteractionModel;
import cn.nukkit.network.protocol.types.ClientPlayMode;
import cn.nukkit.network.protocol.types.InputMode;
import cn.nukkit.network.protocol.types.PlayerActionType;
import cn.nukkit.network.protocol.types.PlayerBlockActionData;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import lombok.Generated;

public class PlayerAuthInputPacket
extends DataPacket {
    public static final byte NETWORK_ID = -112;
    private float yaw;
    private float pitch;
    private float headYaw;
    private Vector3f position;
    private Vector2 motion;
    private final Set<AuthInputAction> inputData = EnumSet.noneOf(AuthInputAction.class);
    private InputMode inputMode;
    private ClientPlayMode playMode;
    private AuthInteractionModel interactionModel;
    private long tick;
    private Vector3f delta;
    private final Map<PlayerActionType, PlayerBlockActionData> blockActionData = new EnumMap<PlayerActionType, PlayerBlockActionData>(PlayerActionType.class);
    private long predictedVehicle;
    private Vector2f analogMoveVector;
    private Vector2f vehicleRotation;
    private Vector2f interactRotation;
    private Vector3f cameraOrientation;
    private Vector2f rawMoveVector;

    @Override
    public byte pid() {
        return -112;
    }

    @Override
    public void decode() {
        this.pitch = this.getLFloat();
        this.yaw = this.getLFloat();
        this.position = this.getVector3f();
        this.motion = new Vector2(this.getLFloat(), this.getLFloat());
        this.headYaw = this.getLFloat();
        long inputData = this.getUnsignedVarLong();
        for (int i = 0; i < AuthInputAction.size(); ++i) {
            if ((inputData & 1L << i) == 0L) continue;
            this.inputData.add(AuthInputAction.from(i));
        }
        this.inputMode = InputMode.fromOrdinal((int)this.getUnsignedVarInt());
        this.playMode = ClientPlayMode.fromOrdinal((int)this.getUnsignedVarInt());
        this.interactionModel = AuthInteractionModel.fromOrdinal((int)this.getUnsignedVarInt());
        this.interactRotation = this.getVector2f();
        this.tick = this.getUnsignedVarLong();
        this.delta = this.getVector3f();
        if (this.inputData.contains((Object)AuthInputAction.PERFORM_BLOCK_ACTIONS)) {
            int arraySize = this.getVarInt();
            if (arraySize > 256) {
                throw new IllegalArgumentException("PlayerAuthInputPacket PERFORM_BLOCK_ACTIONS is too long: " + arraySize);
            }
            block4: for (int i = 0; i < arraySize; ++i) {
                PlayerActionType type = PlayerActionType.from(this.getVarInt());
                switch (type) {
                    case START_DESTROY_BLOCK: 
                    case ABORT_DESTROY_BLOCK: 
                    case CRACK_BLOCK: 
                    case PREDICT_DESTROY_BLOCK: 
                    case CONTINUE_DESTROY_BLOCK: {
                        this.blockActionData.put(type, new PlayerBlockActionData(type, this.getSignedBlockPosition(), this.getVarInt()));
                        continue block4;
                    }
                    default: {
                        this.blockActionData.put(type, new PlayerBlockActionData(type, null, -1));
                    }
                }
            }
        }
        if (this.inputData.contains((Object)AuthInputAction.IN_CLIENT_PREDICTED_IN_VEHICLE)) {
            this.vehicleRotation = this.getVector2f();
            this.predictedVehicle = this.getVarLong();
        }
        this.analogMoveVector = this.getVector2f();
        this.cameraOrientation = this.getVector3f();
        this.rawMoveVector = this.getVector2f();
    }

    @Override
    public void encode() {
        this.encodeUnsupported();
    }

    @Generated
    public String toString() {
        return "PlayerAuthInputPacket(yaw=" + this.getYaw() + ", pitch=" + this.getPitch() + ", headYaw=" + this.getHeadYaw() + ", position=" + this.getPosition() + ", motion=" + this.getMotion() + ", inputData=" + this.getInputData() + ", inputMode=" + (Object)((Object)this.getInputMode()) + ", playMode=" + (Object)((Object)this.getPlayMode()) + ", interactionModel=" + (Object)((Object)this.getInteractionModel()) + ", tick=" + this.getTick() + ", delta=" + this.getDelta() + ", blockActionData=" + this.getBlockActionData() + ", predictedVehicle=" + this.getPredictedVehicle() + ", analogMoveVector=" + this.getAnalogMoveVector() + ", vehicleRotation=" + this.getVehicleRotation() + ", interactRotation=" + this.getInteractRotation() + ", cameraOrientation=" + this.getCameraOrientation() + ", rawMoveVector=" + this.getRawMoveVector() + ")";
    }

    @Generated
    public float getYaw() {
        return this.yaw;
    }

    @Generated
    public float getPitch() {
        return this.pitch;
    }

    @Generated
    public float getHeadYaw() {
        return this.headYaw;
    }

    @Generated
    public Vector3f getPosition() {
        return this.position;
    }

    @Generated
    public Vector2 getMotion() {
        return this.motion;
    }

    @Generated
    public Set<AuthInputAction> getInputData() {
        return this.inputData;
    }

    @Generated
    public InputMode getInputMode() {
        return this.inputMode;
    }

    @Generated
    public ClientPlayMode getPlayMode() {
        return this.playMode;
    }

    @Generated
    public AuthInteractionModel getInteractionModel() {
        return this.interactionModel;
    }

    @Generated
    public long getTick() {
        return this.tick;
    }

    @Generated
    public Vector3f getDelta() {
        return this.delta;
    }

    @Generated
    public Map<PlayerActionType, PlayerBlockActionData> getBlockActionData() {
        return this.blockActionData;
    }

    @Generated
    public long getPredictedVehicle() {
        return this.predictedVehicle;
    }

    @Generated
    public Vector2f getAnalogMoveVector() {
        return this.analogMoveVector;
    }

    @Generated
    public Vector2f getVehicleRotation() {
        return this.vehicleRotation;
    }

    @Generated
    public Vector2f getInteractRotation() {
        return this.interactRotation;
    }

    @Generated
    public Vector3f getCameraOrientation() {
        return this.cameraOrientation;
    }

    @Generated
    public Vector2f getRawMoveVector() {
        return this.rawMoveVector;
    }
}

