/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.network.protocol;

import cn.nukkit.network.protocol.DataPacket;
import java.nio.charset.StandardCharsets;
import lombok.Generated;

public class PacketViolationWarningPacket
extends DataPacket {
    public static final byte NETWORK_ID = -100;
    public PacketViolationType type;
    public PacketViolationSeverity severity;
    public int packetId;
    public String context;

    @Override
    public byte pid() {
        return -100;
    }

    @Override
    public void decode() {
        this.type = PacketViolationType.values()[this.getVarInt() + 1];
        this.severity = PacketViolationSeverity.values()[this.getVarInt()];
        this.packetId = this.getVarInt();
        int contextLength = (int)this.getUnsignedVarInt();
        String context = contextLength > 1024 ? "Context too long: " + contextLength : new String(this.get(contextLength), StandardCharsets.UTF_8);
        this.context = context;
    }

    @Override
    public void encode() {
        this.encodeUnsupported();
    }

    @Generated
    public String toString() {
        return "PacketViolationWarningPacket(type=" + (Object)((Object)this.type) + ", severity=" + (Object)((Object)this.severity) + ", packetId=" + this.packetId + ", context=" + this.context + ")";
    }

    public static enum PacketViolationSeverity {
        UNKNOWN,
        WARNING,
        FINAL_WARNING,
        TERMINATING_CONNECTION;

    }

    public static enum PacketViolationType {
        UNKNOWN,
        MALFORMED_PACKET;

    }
}

