/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.network.protocol;

import cn.nukkit.network.protocol.DataPacket;
import lombok.Generated;

public class MoveEntityDeltaPacket
extends DataPacket {
    public static final byte NETWORK_ID = 111;
    public static final int FLAG_HAS_X = 1;
    public static final int FLAG_HAS_Y = 2;
    public static final int FLAG_HAS_Z = 4;
    public static final int FLAG_HAS_YAW = 8;
    public static final int FLAG_HAS_HEAD_YAW = 16;
    public static final int FLAG_HAS_PITCH = 32;
    public long eid;
    public int flags = 0;
    public float x = 0.0f;
    public float y = 0.0f;
    public float z = 0.0f;
    public double yawDelta = 0.0;
    public double headYawDelta = 0.0;
    public double pitchDelta = 0.0;

    @Override
    public byte pid() {
        return 111;
    }

    @Override
    public void decode() {
        this.decodeUnsupported();
    }

    @Override
    public void encode() {
        this.reset();
        this.putEntityRuntimeId(this.eid);
        this.putByte((byte)this.flags);
        this.putCoordinate(1, this.x);
        this.putCoordinate(2, this.y);
        this.putCoordinate(4, this.z);
        this.putRotation(8, this.yawDelta);
        this.putRotation(16, this.headYawDelta);
        this.putRotation(32, this.pitchDelta);
    }

    private void putCoordinate(int flag, float value) {
        if ((this.flags & flag) != 0) {
            this.putLFloat(value);
        }
    }

    private void putRotation(int flag, double value) {
        if ((this.flags & flag) != 0) {
            this.putByte((byte)(value / 1.40625));
        }
    }

    @Generated
    public String toString() {
        return "MoveEntityDeltaPacket(eid=" + this.eid + ", flags=" + this.flags + ", x=" + this.x + ", y=" + this.y + ", z=" + this.z + ", yawDelta=" + this.yawDelta + ", headYawDelta=" + this.headYawDelta + ", pitchDelta=" + this.pitchDelta + ")";
    }
}

